package io.github.xrickastley.sevenelements.util;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import net.minecraft.class_4587;

public class DelayedRenderer {
	private static final List<BiConsumer<Float, class_4587>> RENDER_CALLS = new CopyOnWriteArrayList<>();

	public static void add(BiConsumer<Float, class_4587> consumer) {
		DelayedRenderer.RENDER_CALLS.add(consumer);
	}

	public static void render(final float tickDelta, final class_4587 matrixStack) {
		DelayedRenderer.RENDER_CALLS.forEach(c -> c.accept(tickDelta, matrixStack));
		DelayedRenderer.RENDER_CALLS.clear();
	}
}
