/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.element;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.factory.SevenElementsParticleTypes;
import io.github.xrickastley.sevenelements.util.Color;
import io.github.xrickastley.sevenelements.util.Colors;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_8909;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Element {
    PHYSICAL(SevenElements.identifier("physical"), ElementSettings.create().setDamageColor(Color.fromRGBAHex("#ffffff")).canBeAura(false)),
    PYRO(SevenElements.identifier("pyro"), ElementSettings.create().setTexture(SevenElements.identifier("textures/element/pyro.png")).setDamageColor(Colors.PYRO).setPriority(2).decayInheritance(false).particleRenderer(new ParticleRenderer((class_2396<? extends class_2394>)class_2398.field_11240, new class_243(0.0, 0.75, 0.0), new class_243(0.125, 0.25, 0.125), 0.025, 2))),
    HYDRO(SevenElements.identifier("hydro"), ElementSettings.create().setTexture(SevenElements.identifier("textures/element/hydro.png")).setDamageColor(Colors.HYDRO).setPriority(2).particleRenderer(new ParticleRenderer((class_2396<? extends class_2394>)class_2398.field_18306, new class_243(0.0, 0.75, 0.0), new class_243(0.25, 0.25, 0.25), 0.025, 2))),
    ANEMO(SevenElements.identifier("anemo"), ElementSettings.create().setTexture(SevenElements.identifier("textures/element/anemo.png")).setDamageColor(Colors.ANEMO).setPriority(2).canBeAura(false)),
    ELECTRO(SevenElements.identifier("electro"), ElementSettings.create().setTexture(SevenElements.identifier("textures/element/electro.png")).setDamageColor(Colors.ELECTRO).setPriority(2)),
    DENDRO(SevenElements.identifier("dendro"), ElementSettings.create().setTexture(SevenElements.identifier("textures/element/dendro.png")).setDamageColor(Colors.DENDRO).setPriority(2).setDecayRate(Decays.DENDRO_DECAY_RATE).particleRenderer(new ParticleRenderer(SevenElementsParticleTypes.TINTED_LEAVES, new class_243(0.0, 0.75, 0.0), new class_243(0.125, 0.25, 0.125), 0.01, 2, "{color: [0, 1, 0, 1]}"))),
    CRYO(SevenElements.identifier("cryo"), ElementSettings.create().setTexture(SevenElements.identifier("textures/element/cryo.png")).setDamageColor(Colors.CRYO).setPriority(2).particleRenderer(new ParticleRenderer((class_2396<? extends class_2394>)class_2398.field_28013, new class_243(0.0, 0.75, 0.0), new class_243(0.125, 0.25, 0.125), 0.01, 2))),
    GEO(SevenElements.identifier("geo"), ElementSettings.create().setTexture(SevenElements.identifier("textures/element/geo.png")).setDamageColor(Colors.GEO).setPriority(2).canBeAura(false)),
    FREEZE(SevenElements.identifier("freeze"), ElementSettings.create().setTexture(SevenElements.identifier("textures/element/cryo.png")).setDamageColor(Color.fromRGBAHex("#b4ffff")).setPriority(2).bypassesCooldown(true).linkToElement(CRYO)),
    BURNING(SevenElements.identifier("burning"), ElementSettings.create().setTexture(SevenElements.identifier("textures/element/pyro.png")).setDamageColor(Colors.PYRO).setPriority(1).setDecayRate(Decays.NO_DECAY_RATE).bypassesCooldown(true).hasAuraTax(false).linkToElement(PYRO)),
    QUICKEN(SevenElements.identifier("quicken"), ElementSettings.create().setTexture(SevenElements.identifier("textures/element/dendro.png")).setDamageColor(Color.fromRGBAHex("#01e858")).setPriority(2).bypassesCooldown(true).linkToElement(DENDRO).linkGaugeDecayIf(application -> ((ElementComponent)ElementComponent.KEY.get((Object)application.getEntity())).hasElementalApplication(BURNING)));

    public static final Codec<Element> CODEC;
    private final class_2960 id;
    private final ElementSettings settings;
    private final List<class_3545<Element, Predicate<ElementalApplication>>> linkedElements;

    private Element(class_2960 id, ElementSettings settings) {
        this.id = id;
        this.settings = settings;
        this.linkedElements = new ArrayList<class_3545<Element, Predicate<ElementalApplication>>>();
        if (settings.linkedElement == null) {
            return;
        }
        if (settings.reverseLinkedElement) {
            this.linkedElements.add((class_3545<Element, Predicate<ElementalApplication>>)new class_3545((Object)settings.linkedElement, settings.linkDecayOnlyIf));
        } else {
            settings.linkedElement.linkedElements.add((class_3545<Element, Predicate<ElementalApplication>>)new class_3545((Object)this, settings.linkDecayOnlyIf));
        }
    }

    public boolean hasDecayInheritance() {
        return this.settings.decayInheritance;
    }

    public boolean hasTexture() {
        return this.settings.texture != null;
    }

    public class_2960 getTexture() {
        return this.settings.texture;
    }

    public boolean hasDamageColor() {
        return this.settings.damageColor != null;
    }

    public Color getDamageColor() {
        return this.settings.damageColor;
    }

    public class_2960 getId() {
        return this.id;
    }

    public boolean canBeAura() {
        return this.settings.canBeAura;
    }

    public int getPriority() {
        return this.settings.priority;
    }

    @Nullable
    public Function<ElementalApplication, Number> getCustomDecayRate() {
        return this.settings.decayRate;
    }

    public boolean bypassesInternalCooldown() {
        return this.settings.bypassesCooldown;
    }

    public boolean hasAuraTax() {
        return this.settings.hasAuraTax;
    }

    public class_2561 getText() {
        String string = this.toString();
        String fallback = string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase();
        return class_2561.method_48321((String)("seven-elements.element." + string.toLowerCase()), (String)fallback);
    }

    public String getString() {
        return this.getText().getString();
    }

    public void renderEffects(class_1309 entity) {
        if (this.settings.particleRenderer == null) {
            return;
        }
        this.settings.particleRenderer.render(entity);
    }

    void reduceLinkedElements(double reduction, ElementalApplication application, boolean isGaugeDecay) {
        ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)application.getEntity());
        if (component == null) {
            return;
        }
        for (class_3545<Element, Predicate<ElementalApplication>> pair : application.getElement().linkedElements) {
            if (!component.hasElementalApplication((Element)((Object)pair.method_15442())) || isGaugeDecay && !((Predicate)pair.method_15441()).test(application)) continue;
            component.getElementalApplication((Element)((Element)((Object)pair.method_15442()))).currentGauge -= reduction;
        }
        ElementComponent.sync((class_1297)application.getEntity());
    }

    static {
        CODEC = class_5699.field_41759.xmap(Element::valueOf, Enum::toString);
    }

    private static class ElementSettings {
        private class_2960 texture;
        private Color damageColor;
        private int priority;
        @Nullable
        private Function<ElementalApplication, Number> decayRate = null;
        private boolean canBeAura = true;
        private boolean decayInheritance = true;
        private boolean bypassesCooldown = false;
        private boolean hasAuraTax = true;
        @Nullable
        private Element linkedElement = null;
        private boolean reverseLinkedElement = false;
        private Predicate<ElementalApplication> linkDecayOnlyIf = entity -> true;
        @Nullable
        private ParticleRenderer particleRenderer = null;

        private ElementSettings() {
        }

        public static ElementSettings create() {
            return new ElementSettings();
        }

        public ElementSettings setTexture(class_2960 texture) {
            this.texture = texture;
            return this;
        }

        public ElementSettings setDamageColor(Color damageColor) {
            this.damageColor = damageColor;
            return this;
        }

        public ElementSettings setPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public ElementSettings setDecayRate(@NotNull Function<ElementalApplication, Number> decayRate) {
            this.decayRate = decayRate;
            return this;
        }

        public ElementSettings canBeAura(boolean aura) {
            this.canBeAura = aura;
            return this;
        }

        public ElementSettings hasAuraTax(boolean auraTax) {
            this.hasAuraTax = auraTax;
            return this;
        }

        public ElementSettings bypassesCooldown(boolean bypassesCooldown) {
            this.bypassesCooldown = bypassesCooldown;
            return this;
        }

        public ElementSettings decayInheritance(boolean decayInheritance) {
            this.decayInheritance = decayInheritance;
            return this;
        }

        public ElementSettings particleRenderer(ParticleRenderer particleRenderer) {
            this.particleRenderer = particleRenderer;
            return this;
        }

        public ElementSettings linkToElement(Element element) {
            this.linkedElement = element;
            return this;
        }

        public ElementSettings linkElement(Element element) {
            this.linkedElement = element;
            this.reverseLinkedElement = true;
            return this;
        }

        public ElementSettings linkGaugeDecay(boolean link) {
            return this.linkGaugeDecayIf(a -> link);
        }

        public ElementSettings linkGaugeDecayIf(Predicate<ElementalApplication> predicate) {
            this.linkDecayOnlyIf = predicate;
            return this;
        }
    }

    private record ParticleRenderer(class_2396<? extends class_2394> particle, class_243 relativePos, class_243 delta, double speed, int count, class_2487 compound) {
        private static final class_5819 random = class_5819.method_43047();

        ParticleRenderer(class_2396<? extends class_2394> particle, class_243 relativePos, class_243 delta, double speed, int count, String nbt) {
            this(particle, relativePos, delta, speed, count, ParticleRenderer.parseCompound(nbt));
        }

        ParticleRenderer(class_2396<? extends class_2394> particle, class_243 relativePos, class_243 delta, double speed, int count) {
            this(particle, relativePos, delta, speed, count, new class_2487());
        }

        private static class_2487 parseCompound(String nbt) {
            try {
                return class_2522.method_10718((String)nbt);
            }
            catch (Exception e) {
                class_8909 e2 = new class_8909("An invalid NBT string was provided!");
                e2.addSuppressed(e);
                throw e2;
            }
        }

        private class_2394 getParticle(class_1937 world) {
            return (class_2394)this.particle.method_29138().codec().parse((DynamicOps)world.method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)this.compound).getOrThrow();
        }

        private void render(class_1309 entity) {
            if (!entity.method_37908().field_9236) {
                return;
            }
            class_238 box = entity.method_5829();
            class_243 pos = entity.method_19538().method_1019(this.relativePos.method_18805(box.method_17939(), box.method_17940(), box.method_17941()));
            if (this.count == 0) {
                this.addSingleParticle(entity, pos);
            } else {
                this.addMultipleParticles(entity, pos);
            }
        }

        private void addSingleParticle(class_1309 entity, class_243 pos) {
            class_1937 world = entity.method_37908();
            double velX = this.speed * this.delta.field_1352;
            double velY = this.speed * this.delta.field_1351;
            double velZ = this.speed * this.delta.field_1350;
            world.method_8406(this.getParticle(world), pos.field_1352, pos.field_1351, pos.field_1350, velX, velY, velZ);
        }

        private void addMultipleParticles(class_1309 entity, class_243 pos) {
            class_1937 world = entity.method_37908();
            for (int i = 0; i < this.count; ++i) {
                double randX = random.method_43059() * this.delta.field_1352;
                double randY = random.method_43059() * this.delta.field_1351;
                double randZ = random.method_43059() * this.delta.field_1350;
                double velX = random.method_43059() * this.speed;
                double velY = random.method_43059() * this.speed;
                double velZ = random.method_43059() * this.speed;
                world.method_8406(this.getParticle(world), pos.field_1352 + randX, pos.field_1351 + randY, pos.field_1350 + randZ, velX, velY, velZ);
            }
        }
    }

    private static class Decays {
        private static final Function<ElementalApplication, Number> NO_DECAY_RATE = a -> 0;
        private static final Function<ElementalApplication, Number> DENDRO_DECAY_RATE = application -> {
            ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)application.getEntity());
            return component.hasElementalApplication(Element.valueOf("BURNING")) ? Math.max(0.02, application.getDefaultDecayRate() * 2.0) : application.getDefaultDecayRate();
        };

        private Decays() {
        }
    }
}

