package io.github.xrickastley.sevenelements.element.reaction;

import org.jetbrains.annotations.Nullable;

import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.entity.DendroCoreEntity;
import io.github.xrickastley.sevenelements.entity.SevenElementsEntityTypes;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3730;

public abstract sealed class AbstractBloomElementalReaction
	extends ElementalReaction
	permits DendroBloomElementalReaction, HydroBloomElementalReaction, QuickenBloomElementalReaction
{
	AbstractBloomElementalReaction(Settings settings) {
		super(settings);
	}

	@Override
	protected void onReaction(class_1309 entity, ElementalApplication auraElement, ElementalApplication triggeringElement, double reducedGauge, @Nullable class_1309 origin) {
		final class_1937 world = entity.method_37908();

		if (!(world instanceof final class_3218 serverWorld)) return;

		final DendroCoreEntity dendroCore = SevenElementsEntityTypes.DENDRO_CORE.method_5883(serverWorld, class_3730.field_16461);
		dendroCore.addOwner(origin);
		dendroCore.method_33574(entity.method_19538());

		serverWorld.method_30736(dendroCore);
	}
}
