package io.github.xrickastley.sevenelements.element.reaction;

import org.jetbrains.annotations.Nullable;

import io.github.xrickastley.sevenelements.element.ElementalApplication;
import net.minecraft.class_1309;
import net.minecraft.class_3218;

public abstract class AdditiveElementalReaction extends ElementalReaction {
	final double amplifier;

	protected AdditiveElementalReaction(Settings settings, double amplifier) {
		super(settings);

		this.amplifier = amplifier;
	}

	public float applyAmplifier(class_1309 entity, float damage) {
		return entity.method_37908() instanceof final class_3218 world
			? (float) applyAmplifier(world, (double) damage)
			: damage;
	}

	public float applyAmplifier(class_3218 world, float damage) {
		return (float) applyAmplifier(world, (double) damage);
	}

	public double applyAmplifier(class_1309 entity, double damage) {
		return entity.method_37908() instanceof final class_3218 world
			? applyAmplifier(world, (double) damage)
			: damage;
	}

	public double applyAmplifier(class_3218 world, double damage) {
		return getDamageBonus(world) + damage;
	}

	public double getAmplifier() {
		return this.amplifier;
	}

	public double getDamageBonus(class_3218 world) {
		return ElementalReaction.getReactionDamage(world, amplifier);
	}

	@Override
	protected void onReaction(class_1309 entity, ElementalApplication auraElement, ElementalApplication triggeringElement, double reducedGauge, @Nullable class_1309 origin) {}
}
