package io.github.xrickastley.sevenelements.gui.screen.ingame;

import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.factory.SevenElementsSoundEvents;
import io.github.xrickastley.sevenelements.networking.FinishElementalInfusionS2CPayload;
import io.github.xrickastley.sevenelements.screen.ElementalInfusionScreenHandler;
import io.github.xrickastley.sevenelements.util.ClientConfig;
import io.github.xrickastley.sevenelements.util.MathHelper2;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_8012;

public class ElementalInfusionScreen extends class_465<ElementalInfusionScreenHandler> {
	private static final class_2960 TEXTURE = SevenElements.identifier("textures/gui/container/infusion_table.png");

	private static final class_2960 SLOT_DISABLED_TEXTURE = class_2960.method_60656("container/enchanting_table/enchantment_slot_disabled");
	private static final class_2960 SLOT_HIGHLIGHTED_TEXTURE = class_2960.method_60656("container/enchanting_table/enchantment_slot_highlighted");
	private static final class_2960 SLOT_TEXTURE = class_2960.method_60656("container/enchanting_table/enchantment_slot");

	private static final class_2960 LEVEL_DISABLED_TEXTURE = SevenElements.identifier("container/infusion_table/level_disabled");
	private static final class_2960 LEVEL_ENABLED_TEXTURE = SevenElements.identifier("container/infusion_table/level_enabled");

	private static final int LOCK_TICKS = 10;
	private final class_1657 player;
	private boolean locked = false;
	private long lockedAt;
	private long tooltipDisplayedAt;

	public ElementalInfusionScreen(ElementalInfusionScreenHandler handler, class_1661 inventory, class_2561 title) {
		super(handler, inventory, title);

		this.field_2779 = 246;
		this.field_2792 = 176;
		this.field_25269 = 8;
		this.field_25270 = this.field_2779 - 94;
		this.player = inventory.field_7546;
	}

	@Override
	protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
		final int x = (field_22789 - field_2792) / 2;
		final int y = (field_22790 - field_2779) / 2;

		context.method_25290(class_1921::method_62277, TEXTURE, x, y, 0, 0, field_2792, field_2779, 256, 256);

		this.drawElements(context, x, y);
		this.drawInfuseButton(context, x, y, mouseX, mouseY);

		final class_1735 slot = this.field_2797.getResultSlot();

		if (this.displayTooltip() && slot.method_7681())
			context.method_51434(this.field_22793, this.method_51454(slot.method_7677()), x + slot.field_7873 + 16, y + slot.field_7872 + 12);
	}

	private void drawElements(class_332 context, final int x, final int y) {
		context.method_25290(class_1921::method_62277, Element.PYRO.getTexture(), x + 76, y + 18, 0, 0, 24, 24, 24, 24);
		context.method_25290(class_1921::method_62277, Element.HYDRO.getTexture(), x + 107, y + 33, 0, 0, 24, 24, 24, 24);
		context.method_25290(class_1921::method_62277, Element.ANEMO.getTexture(), x + 115, y + 63, 0, 0, 24, 24, 24, 24);
		context.method_25290(class_1921::method_62277, Element.ELECTRO.getTexture(), x + 94, y + 92, 0, 0, 24, 24, 24, 24);
		context.method_25290(class_1921::method_62277, Element.DENDRO.getTexture(), x + 59, y + 92, 0, 0, 24, 24, 24, 24);
		context.method_25290(class_1921::method_62277, Element.CRYO.getTexture(), x + 37, y + 63, 0, 0, 24, 24, 24, 24);
		context.method_25290(class_1921::method_62277, Element.GEO.getTexture(), x + 45, y + 33, 0, 0, 24, 24, 24, 24);
	}

	private void drawInfuseButton(class_332 context, final int x, final int y, final int mouseX, final int mouseY) {
		if (!field_2797.getResultSlot().method_7681()) return;

		final int x1 = x + 43;
		final int y1 = y + 128;
		final int x2 = x1 + 90;
		final int y2 = y1 + 19;

		final class_2960 texture = !this.isEnabled()
			? SLOT_DISABLED_TEXTURE
			: MathHelper2.inRange(mouseX, x1, x2) && MathHelper2.inRange(mouseY, y1, y2)
				? SLOT_HIGHLIGHTED_TEXTURE
				: SLOT_TEXTURE;

		final class_2960 expTexture = this.isEnabled()
			? LEVEL_ENABLED_TEXTURE
			: LEVEL_DISABLED_TEXTURE;

		final int color = MathHelper2.inRange(mouseX, x1, x2) && MathHelper2.inRange(mouseY, y1, y2) && this.isEnabled()
			? class_8012.field_46767
			: 0x685E4A;

		context.method_52706(class_1921::method_62277, texture, x1, y1, 90, 19);
		context.method_52706(class_1921::method_62277, expTexture, x2 - 24, y2 - 16, 24, 16);
		context.method_51439(this.field_22793, class_2561.method_43471("container.seven-elements.infusion_table.infuse"), x1 + 6, y1 + 6, color, false);
	}

	@Override
	public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
		this.method_25420(context, mouseX, mouseY, delta);
		super.method_25394(context, mouseX, mouseY, delta);
		this.method_2380(context, mouseX, mouseY);
	}

	@Override
	protected void method_25426() {
		super.method_25426();

		field_25267 = (field_2792 - field_22793.method_27525(field_22785)) / 2;
	}

	@Override
	public boolean method_25402(double mouseX, double mouseY, int button) {
		return this.checkMouseClick(mouseX, mouseY, button)
			|| super.method_25402(mouseX, mouseY, button);
	}

	private boolean checkMouseClick(double mouseX, double mouseY, int button) {
		final int x = (field_22789 - field_2792) / 2;
		final int y = (field_22790 - field_2779) / 2;

		final int x1 = x + 43;
		final int y1 = y + 128;
		final int x2 = x1 + 90;
		final int y2 = y1 + 19;

		if (!MathHelper2.inRange(mouseX, x1, x2) || !MathHelper2.inRange(mouseY, y1, y2)) return false;

		if (!this.isEnabled()) return false;

		this.lock();
		this.field_22787.field_1761.method_2900(field_2797.field_7763, 0);
		this.field_22787.field_1724.method_5783(SevenElementsSoundEvents.ITEM_INFUSION, 1f, 1f);

		return true;
	}

	public void finishElementalInfusion(FinishElementalInfusionS2CPayload payload) {
		this.unlock();
	}

	private void lock() {
		this.locked = true;
		this.lockedAt = player.method_37908().method_8510();
		this.field_2797.getResultSlot().lock();
	}

	private void unlock() {
		this.locked = false;
		this.field_2797.getResultSlot().unlock();
		this.tooltipDisplayedAt = player.method_37908().method_8510();
	}

	private boolean isEnabled() {
		return field_2797.canInfuse(this.player) && !this.isLocked();
	}

	private boolean isLocked() {
		return locked || this.lockedAt + ElementalInfusionScreen.LOCK_TICKS >= this.player.method_37908().method_8510();
	}

	private boolean displayTooltip() {
		final ClientConfig config = ClientConfig.get();

		return config.rendering.text.displayTooltipAfterInfusion
			&& this.tooltipDisplayedAt + config.rendering.text.tooltipDisplayTicks >= this.player.method_37908().method_8510()
			&& (this.field_2787 == null || !this.field_2787.method_7681());
	}
}
