package io.github.xrickastley.sevenelements.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;

import java.util.Collection;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.element.InternalCooldownType;
import io.github.xrickastley.sevenelements.entity.DendroCoreEntity;
import io.github.xrickastley.sevenelements.factory.SevenElementsAttributes;
import io.github.xrickastley.sevenelements.factory.SevenElementsGameRules;
import io.github.xrickastley.sevenelements.factory.SevenElementsSoundEvents;
import io.github.xrickastley.sevenelements.interfaces.ILivingEntity;
import io.github.xrickastley.sevenelements.interfaces.IPlayerEntity;
import io.github.xrickastley.sevenelements.networking.ShowElementalDamageS2CPayload;
import io.github.xrickastley.sevenelements.registry.SevenElementsDamageTypeTags;
import io.github.xrickastley.sevenelements.util.BoxUtil;

import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5132;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin
	extends class_1297
	implements ILivingEntity
{
	public LivingEntityMixin(final class_1299<? extends class_1309> entityType, final class_1937 world) {
		super(entityType, world);
		throw new AssertionError();
	}

	@Unique
	private float sevenelements$subdamage;
	@Unique
	private boolean sevenelements$blockedByCrystallizeShield = true; // true ONLY if ALL received DMG is blocked.

	@ModifyReturnValue(
		method = "createLivingAttributes",
		at = @At("RETURN")
	)
	private static class_5132.class_5133 addToLivingAttributes(class_5132.class_5133 builder) {
		return SevenElementsAttributes.apply(builder);
	}

	@Inject(
		method = "onStatusEffectsRemoved",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/entity/effect/StatusEffect;onRemoved(Lnet/minecraft/entity/attribute/AttributeContainer;)V",
			shift = At.Shift.AFTER
		)
	)
	private void triggerEntityOnRemoved(Collection<class_1293> effects, CallbackInfo ci, @Local class_1293 effect) {
		effect
			.method_5579()
			.comp_349()
			.onRemoved((class_1309)(class_1297) this, effect.method_5578());
	}

	@Inject(
		method = "tick",
		at = @At("HEAD")
	)
	private void applyNaturalElements(CallbackInfo ci) {
		if (!(this.method_37908() instanceof final class_3218 world)) return;

		if (this.method_5799() && world.method_64395().method_8355(SevenElementsGameRules.HYDRO_FROM_WATER)) {
			final ElementComponent component = ElementComponent.KEY.get(this);

			component.addElementalApplication(
				Element.HYDRO,
				InternalCooldownContext
					.ofType(null, "seven-elements:natural_environment", InternalCooldownType.INTERVAL_ONLY)
					.forced(),
				1.0
			);
		} else if (this.method_55667().method_26204() == class_2246.field_10036 && world.method_64395().method_8355(SevenElementsGameRules.PYRO_FROM_FIRE)) {
			final ElementComponent component = ElementComponent.KEY.get(this);

			component.addElementalApplication(
				Element.PYRO,
				InternalCooldownContext
					.ofType(null, "seven-elements:natural_environment", InternalCooldownType.INTERVAL_ONLY)
					.forced(),
				1.0
			);
		}
	}

	@Inject(
		method = "damage",
		at = @At("HEAD")
	)
	private void resetCrystallizeShieldBlockedState(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
		this.sevenelements$blockedByCrystallizeShield = false;
	}

	@ModifyVariable(
		method = "applyDamage",
		at = @At(
			value = "INVOKE_ASSIGN",
			target = "Lnet/minecraft/entity/LivingEntity;modifyAppliedDamage(Lnet/minecraft/entity/damage/DamageSource;F)F"
		),
		ordinal = 0,
		argsOnly = true
	)
	private float applyCrystallizeShield(float amount, @Local(argsOnly = true) class_1282 source) {
		final ElementComponent component = ElementComponent.KEY.get(this);
		final float finalAmount = amount - component.reduceCrystallizeShield(source, amount);

		if (finalAmount < amount)
			this.method_37908().method_8396(null, this.method_24515(), SevenElementsSoundEvents.CRYSTALLIZE_SHIELD_HIT, class_3419.field_15248, 1.0f, 1.0f);

		if (finalAmount <= 0) this.sevenelements$blockedByCrystallizeShield = true;

		return finalAmount;
	}

	@Inject(
		method = "damage",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/entity/LivingEntity;applyDamage(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/damage/DamageSource;F)V",
			shift = At.Shift.AFTER
		),
		cancellable = true
	)
	private void cancelIfFullyBlocked(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
		if (this.sevenelements$blockedByCrystallizeShield) cir.setReturnValue(false);
	}

	@ModifyExpressionValue(
		method = "damage",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/entity/damage/DamageSource;isIn(Lnet/minecraft/registry/tag/TagKey;)Z",
			ordinal = 5
		)
	)
	private boolean preventKnockbackIfCrystallize(boolean original, @Local(argsOnly = true) class_1282 source, @Share("sevenelements$hasCrystallizeShield") LocalBooleanRef hasCrystallizeShield) {
		final ElementComponent component = ElementComponent.KEY.get(this);

		return original || component.reducedCrystallizeShield();
	}

	@Inject(
		method = "applyDamage",
		at = @At("TAIL")
	)
	private void elementDamageHandler(class_3218 world, class_1282 source, float _amount, CallbackInfo ci, @Local(ordinal = 1) float amount) {
		this.sevenelements$triggerDendroCoreReactions(world, source);

		if (!source.sevenelements$displayDamage()) return;

		final ElementalDamageSource eds = source instanceof final ElementalDamageSource eds2
			? eds2
			: new ElementalDamageSource(source, ElementalApplications.gaugeUnits((class_1309)(class_1297) this, Element.PHYSICAL, 0), InternalCooldownContext.ofNone(source.method_5529()));

		sevenelements$subdamage += amount;

		if (sevenelements$subdamage < 1) return;

		final float extra = sevenelements$subdamage - (float) Math.floor(sevenelements$subdamage);

		sevenelements$subdamage = (float) Math.floor(sevenelements$subdamage);

		final class_238 boundingBox = this.method_5829();

		final double x = this.method_23317() + (boundingBox.method_17939() * 1.25 * Math.random());
		final double y = this.method_23318() + (boundingBox.method_17940() * 0.50 * Math.random()) + 0.50;
		final double z = this.method_23321() + (boundingBox.method_17941() * 1.25 * Math.random());
		final class_243 pos = new class_243(x, y, z);
		final boolean isCrit = eds.getOriginalSource() != null && source.method_5529() instanceof final class_1657 player && ((IPlayerEntity) player).sevenelements$isCrit(eds.getOriginalSource());

		final Element element = eds.getElementalApplication().getElement();
		final ShowElementalDamageS2CPayload showElementalDMGPacket = new ShowElementalDamageS2CPayload(pos, element, sevenelements$subdamage, isCrit);

		sevenelements$subdamage = extra;

		for (final class_3222 player : PlayerLookup.tracking(this)) {
			if (player.method_5628() == this.method_5628()) return;

			ServerPlayNetworking.send(player, showElementalDMGPacket);
		}
	}

	@ModifyConstant(
		method = "damage",
		constant = @Constant(intValue = 20, ordinal = 0)
	)
	private int changeTimeUntilRegen(int original, @Local(argsOnly = true) class_1282 source) {
		return source.method_48789(SevenElementsDamageTypeTags.PREVENTS_COOLDOWN_TRIGGER)
			? 10
			: original;
	}

	@Unique
	private void sevenelements$triggerDendroCoreReactions(final class_3218 world, final class_1282 source) {
		if (!(source instanceof final ElementalDamageSource eds)) return;

		final Element element = eds.getElementalApplication().getElement();

		if (element != Element.PYRO && element != Element.ELECTRO) return;

		this.method_37908()
			.method_8390(DendroCoreEntity.class, BoxUtil.multiplyBox(this.method_5829(), 2), dc -> true)
			.forEach(dc -> dc.method_64397(world, source, 1));
	}

	@Unique
	@Override
	public void sevenelements$setBlockedByCrystallizeShield(boolean blocked) {
		this.sevenelements$blockedByCrystallizeShield = blocked;
	}
}
