package io.github.xrickastley.sevenelements.renderer;

import java.util.OptionalDouble;
import java.util.SequencedMap;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_1921.class_4688;
import net.minecraft.class_1921.class_4750;
import net.minecraft.class_2960;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_4668.class_4677;
import net.minecraft.class_9799;
import net.minecraft.class_9851;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;

public class SevenElementsRenderLayer {
	private static final class_1921 TRIANGLES = class_1921.method_24048(
		"seven-elements:triangles",
		class_1921.field_32772,
		SevenElementsRenderPipelines.TRIANGLES,
		class_4688.method_23598().method_24297(class_4750.field_21853)
	);

	private static final class_1921 TRIANGLE_FAN = class_1921.method_24048(
		"seven-elements:triangle_fan",
		class_1921.field_32772,
		SevenElementsRenderPipelines.TRIANGLE_FAN,
		class_4688.method_23598().method_24297(class_4750.field_21853)
	);

	private static final class_1921 TRIANGLE_STRIP = class_1921.method_24048(
		"seven-elements:triangle_strip",
		class_1921.field_32772,
		SevenElementsRenderPipelines.TRIANGLE_STRIP,
		class_4688.method_23598().method_24297(class_4750.field_21853)
	);

	private static final class_1921 QUADS = class_1921.method_24048(
		"seven-elements:quads",
		class_1921.field_32772,
		SevenElementsRenderPipelines.QUADS,
		class_4688.method_23598().method_24297(class_4750.field_21853)
	);

	private static final class_1921 THIN_LINES = class_1921.method_24048(
		"seven-elements:thin_lines",
		class_1921.field_32772,
		SevenElementsRenderPipelines.LINES,
		class_4688.method_23598()
			.method_23609(new class_4677(OptionalDouble.of(5)))
			.method_24297(class_4750.field_21853)
	);

	private static final class_1921 THICK_LINES = class_1921.method_24048(
		"seven-elements:thick_lines",
		class_1921.field_32772,
		SevenElementsRenderPipelines.LINES,
		class_4688.method_23598()
			.method_23609(new class_4677(OptionalDouble.of(10)))
			.method_24297(class_4750.field_21853)
	);

	private static final Function<class_2960, class_1921> ELEMENTS = class_156.method_34866(
		texture -> {
			class_4688 multiPhaseParameters = class_4688.method_23598()
				.method_34577(new class_4668.class_4683(texture, class_9851.field_52395, false))
				.method_24297(class_4750.field_21853);

			return class_1921.method_24048(
				"seven-elements:elements",
				class_1921.field_32772,
				SevenElementsRenderPipelines.ELEMENTS,
				multiPhaseParameters
			);
		}
	);

	private static final class_1921 WORLD_TEXT = class_1921.method_24048(
		"seven-elements:world/text",
		class_1921.field_32772,
		SevenElementsRenderPipelines.WORLD_TEXT,
		class_4688.method_23598().method_24297(class_4750.field_21853)
	);

	private static final class_1921 INNER_CHARGE_LINE = class_1921.method_24048(
		"seven-elements:world/charge_line/inner",
		class_1921.field_32772,
		SevenElementsRenderPipelines.CHARGE_LINE,
		class_4688.method_23598()
			.method_23609(new class_4677(OptionalDouble.of(2.0)))
			.method_24297(class_4750.field_21853)
	);

	private static final class_1921 OUTER_CHARGE_LINE = class_1921.method_24048(
		"seven-elements:world/charge_line/outer",
		class_1921.field_32772,
		SevenElementsRenderPipelines.CHARGE_LINE,
		class_4688.method_23598()
			.method_23609(new class_4677(OptionalDouble.of(6.0)))
			.method_24297(class_4750.field_21853)
	);

	private static final class_1921 SPHERE = class_1921.method_24048(
		"seven-elements:sphere",
		class_1921.field_32772,
		SevenElementsRenderPipelines.SPHERE,
		class_4688.method_23598().method_24297(class_4750.field_21853)
	);

	private static final SequencedMap<class_1921, class_9799> WORLD_TEXT_SEQUENCED_MAP = class_156.method_654(
		new Object2ObjectLinkedOpenHashMap<>(), map -> {
			map.put(SevenElementsRenderLayer.WORLD_TEXT, new class_9799(class_1921.field_32772));
		}
	);

	public static class_1921 getTriangles() {
		return SevenElementsRenderLayer.TRIANGLES;
	}

	public static class_1921 getTriangleFan() {
		return SevenElementsRenderLayer.TRIANGLE_FAN;
	}

	public static class_1921 getTriangleStrip() {
		return SevenElementsRenderLayer.TRIANGLE_STRIP;
	}

	public static class_1921 getQuads() {
		return SevenElementsRenderLayer.QUADS;
	}

	public static class_1921 getThinLines() {
		return SevenElementsRenderLayer.THIN_LINES;
	}

	public static class_1921 getThickLines() {
		return SevenElementsRenderLayer.THICK_LINES;
	}

	public static Function<class_2960, class_1921> getElements() {
		return SevenElementsRenderLayer.ELEMENTS;
	}

	public static class_1921 getElements(class_2960 texture) {
		return SevenElementsRenderLayer.ELEMENTS.apply(texture);
	}

	public static class_1921 getWorldText() {
		return SevenElementsRenderLayer.WORLD_TEXT;
	}

	public static class_1921 getInnerChargeLine() {
		return SevenElementsRenderLayer.INNER_CHARGE_LINE;
	}

	public static class_1921 getOuterChargeLine() {
		return SevenElementsRenderLayer.OUTER_CHARGE_LINE;
	}

	public static class_1921 getSphere() {
		return SevenElementsRenderLayer.SPHERE;
	}

	public static class_4597.class_4598 getWorldTextImmediate() {
		return class_4597.method_22992(WORLD_TEXT_SEQUENCED_MAP, new class_9799(class_1921.field_32774));
	}
}
