package io.github.xrickastley.sevenelements.renderer;

import com.mojang.blaze3d.pipeline.RenderPipeline;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_9799;
import org.jetbrains.annotations.Nullable;

import io.github.xrickastley.sevenelements.mixin.client.BufferBuilderAccessor;

public class SevenElementsRenderer {
	private static final List<class_9799> ALLOCATORS = new ArrayList<>();

	public static class_287 createBuffer(final class_9799 allocator, final RenderPipeline pipeline) {
		return SevenElementsRenderer.createBuffer((class_287) null, allocator, pipeline);
	}

	public static class_287 createBuffer(final @Nullable class_287 buffer, final class_9799 allocator, final RenderPipeline pipeline) {
		return buffer == null || !((BufferBuilderAccessor) buffer).isBuilding()
			? new class_287(allocator, pipeline.getVertexFormatMode(), pipeline.getVertexFormat())
			: buffer;
	}

	public static class_9799 createAllocator(final Supplier<class_1921> layer) {
		return SevenElementsRenderer.createAllocator(layer.get());
	}

	public static class_9799 createAllocator(final class_1921 layer) {
		return SevenElementsRenderer.createAllocator(layer.method_22722());
	}

	public static class_9799 createAllocator(final int size) {
		final class_9799 allocator = new class_9799(size);

		SevenElementsRenderer.ALLOCATORS.add(allocator);

		return allocator;
	}

	public static void close() {
		SevenElementsRenderer.ALLOCATORS.forEach(class_9799::close);
	}
}
