package io.github.xrickastley.sevenelements.util;

import com.mojang.serialization.Codec;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_8909;
import org.slf4j.helpers.MessageFormatter;

public class NbtHelper {
	public static <T> T get(class_2487 nbt, String key, Codec<T> codec) {
		return nbt.method_67491(key, codec)
			.orElseThrow(() -> new class_8909("Expected value for required field: " + key));
	}

	public static <T> List<T> getList(class_2487 nbt, String key, Codec<T> entryCodec) {
		final List<T> result = new ArrayList<>();
		final class_2499 list = nbt.method_68569(key);

		for (int i = 0; i < list.size(); i++) {
			final class_2520 element = list.get(i);

			entryCodec
				.parse(class_2509.field_11560, element)
				.resultOrPartial(createErrorConsumer("Failed to read entry at array[{}] ({})", i, element))
				.ifPresent(result::add);
		}

		return result;
	}

	public static <T> void putList(class_2487 nbt, String key, Codec<T> entryCodec, List<T> list) {
		final class_2499 result = new class_2499();

		for (int i = 0; i < list.size(); i++) {
			final T element = list.get(i);

			entryCodec
				.encodeStart(class_2509.field_11560, element)
				.resultOrPartial(createErrorConsumer("Failed to write entry at array[{}] ({})", i, element))
				.ifPresent(result::add);
		}

		nbt.method_10566(key, result);
	}

	private static Consumer<String> createErrorConsumer(final String message, final Object... arguments) {
		return err -> {
			throw new class_8909(MessageFormatter.arrayFormat(message, arguments) + ": " + err);
		};
	}
}
