/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.element;

import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.events.ElementEvents;
import io.github.xrickastley.sevenelements.exception.ElementalApplicationOperationException;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;
import io.github.xrickastley.sevenelements.util.JavaScriptUtil;
import io.github.xrickastley.sevenelements.util.TextHelper;
import java.text.DecimalFormat;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public final class DurationElementalApplication
extends ElementalApplication {
    private double duration;

    DurationElementalApplication(class_1309 entity, Element element, UUID uuid, double gaugeUnits, double duration) {
        super(ElementalApplication.Type.DURATION, entity, element, uuid, gaugeUnits, true);
        this.duration = duration;
    }

    static ElementalApplication fromNbt(class_1309 entity, class_2487 nbt, long syncedAt) {
        Element element = Element.valueOf(nbt.method_10558("Element"));
        UUID uuid = nbt.method_25926("UUID");
        double gaugeUnits = nbt.method_10574("GaugeUnits");
        double duration = nbt.method_10574("Duration");
        DurationElementalApplication application = new DurationElementalApplication(entity, element, uuid, gaugeUnits, duration);
        application.currentGauge = nbt.method_10574("CurrentGauge");
        application.appliedAt = nbt.method_10537("AppliedAt");
        return application;
    }

    public double getDuration() {
        return this.duration;
    }

    @Override
    protected double getDefaultDecayRate() {
        return 0.0;
    }

    @Override
    public int getRemainingTicks() {
        return (int)((double)this.appliedAt + this.duration - (double)this.entity.method_37908().method_8510());
    }

    @Override
    public class_2561 getText(@Nullable DecimalFormat gaugeFormat, @Nullable DecimalFormat durationFormat) {
        gaugeFormat = JavaScriptUtil.nullishCoalesing(gaugeFormat, GAUGE_UNIT_FORMAT);
        durationFormat = JavaScriptUtil.nullishCoalesing(durationFormat, DURATION_FORMAT);
        return TextHelper.color(class_2561.method_43469((String)"formats.seven-elements.elemental_application.duration", (Object[])new Object[]{gaugeFormat.format(this.currentGauge), this.element.getString(), durationFormat.format(this.duration / 20.0)}), this.element.getDamageColor());
    }

    public class_2561 getTimerText() {
        return this.getTimerText(GAUGE_UNIT_FORMAT, DURATION_FORMAT);
    }

    public class_2561 getTimerText(@Nullable String gaugeFormat) {
        return this.getTimerText(ClassInstanceUtil.mapOrNull(gaugeFormat, DecimalFormat::new), DURATION_FORMAT);
    }

    public class_2561 getTimerText(@Nullable DecimalFormat gaugeFormat) {
        return this.getTimerText(gaugeFormat, DURATION_FORMAT);
    }

    public class_2561 getTimerText(@Nullable String gaugeFormat, @Nullable String durationFormat) {
        return this.getTimerText(ClassInstanceUtil.mapOrNull(gaugeFormat, DecimalFormat::new), ClassInstanceUtil.mapOrNull(durationFormat, DecimalFormat::new));
    }

    public class_2561 getTimerText(@Nullable DecimalFormat gaugeFormat, @Nullable DecimalFormat durationFormat) {
        gaugeFormat = JavaScriptUtil.nullishCoalesing(gaugeFormat, GAUGE_UNIT_FORMAT);
        durationFormat = JavaScriptUtil.nullishCoalesing(durationFormat, DURATION_FORMAT);
        return TextHelper.color(class_2561.method_43469((String)"formats.seven-elements.elemental_application.duration.timer", (Object[])new Object[]{gaugeFormat.format(this.currentGauge), this.element.getString(), durationFormat.format((double)this.getRemainingTicks() / 20.0)}), this.element.getDamageColor());
    }

    @Override
    public boolean isEmpty() {
        return this.currentGauge <= 0.0 || (double)this.entity.method_37908().method_8510() >= (double)this.appliedAt + this.duration;
    }

    @Override
    public void reapply(ElementalApplication application) {
        if (application.element != this.element) {
            throw new ElementalApplicationOperationException(ElementalApplicationOperationException.Operation.REAPPLICATION_INVALID_ELEMENT, this, application);
        }
        if (application.type != this.type || !(application instanceof DurationElementalApplication)) {
            throw new ElementalApplicationOperationException(ElementalApplicationOperationException.Operation.REAPPLICATION_INVALID_TYPES, this, application);
        }
        DurationElementalApplication durationApp = (DurationElementalApplication)application;
        this.currentGauge = this.gaugeUnits = Math.max(this.gaugeUnits, application.gaugeUnits);
        this.duration = durationApp.duration;
        this.appliedAt = durationApp.appliedAt;
        ((ElementEvents.ElementReapplied)ElementEvents.REAPPLIED.invoker()).onElementReapplied(this.element, this);
        ElementComponent.sync((class_1297)this.entity);
    }

    @Override
    public ElementalApplication asAura() {
        throw new UnsupportedOperationException("This method is unsupported on Elemental Applications with a DURATION type!");
    }

    @Override
    public ElementalApplication asNonAura() {
        throw new UnsupportedOperationException("This method is unsupported on Elemental Applications with a DURATION type!");
    }

    @Override
    public class_2487 asNbt() {
        class_2487 nbt = super.asNbt();
        nbt.method_10549("Duration", this.duration);
        return nbt;
    }

    @Override
    public void updateFromNbt(class_2520 nbt, long syncedAt) {
        super.updateFromNbt(nbt, syncedAt);
        ElementalApplication application = ElementalApplications.fromNbt(this.entity, nbt, syncedAt);
        this.duration = ((DurationElementalApplication)application).duration;
        this.appliedAt = application.appliedAt;
    }

    public String toString() {
        return String.format("%s@%s[type=DURATION, element=%s, gaugeUnits=%s, duration=%.2f]", this.getClass().getSimpleName(), Integer.toHexString(this.hashCode()), this.getElement().toString(), this.getGaugeUnits(), this.getDuration());
    }
}

