/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.renderer.genshin;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.networking.PayloadHandler;
import io.github.xrickastley.sevenelements.networking.ShowElectroChargeS2CPayload;
import io.github.xrickastley.sevenelements.util.BoxUtil;
import io.github.xrickastley.sevenelements.util.ClientConfig;
import io.github.xrickastley.sevenelements.util.Color;
import io.github.xrickastley.sevenelements.util.Colors;
import io.github.xrickastley.sevenelements.util.Ease;
import io.github.xrickastley.sevenelements.util.Functions;
import io.github.xrickastley.sevenelements.util.JavaScriptUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_8710;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public final class SpecialEffectsRenderer
implements PayloadHandler<ShowElectroChargeS2CPayload> {
    private static final int MAX_TICKS = 10;
    private static final double POISSON_DENSITY = 1.5;
    private static final class_5819 RANDOM = class_5819.method_43047();
    private static final int CHARGE_ITERATIONS = 4;
    private final List<Entry> entries = new ArrayList<Entry>();
    private final Multimap<class_1309, ChargeLinePositions> chargePositions = HashMultimap.create();

    public static boolean shouldRender(class_1297 entity) {
        class_310 client = class_310.method_1551();
        return entity.method_5805() && (entity != client.field_1724 || client.field_1773.method_19418().method_19333());
    }

    @Override
    public class_8710.class_9154<ShowElectroChargeS2CPayload> getPayloadId() {
        return ShowElectroChargeS2CPayload.ID;
    }

    public void receive(ShowElectroChargeS2CPayload payload, ClientPlayNetworking.Context context) {
        class_746 player = context.player();
        class_1937 world = player.method_37908();
        class_1297 mainEntity = world.method_8469(payload.mainEntity());
        if (mainEntity == null) {
            SevenElements.sublogger().warn("Received packet for unknown main Electro-Charged entity, ignoring!");
            return;
        }
        this.entries.add(new ElectroChargedEffect(mainEntity, payload.otherEntities().stream().map(arg_0 -> ((class_1937)world).method_8469(arg_0)).filter(e -> e != null).toList()));
    }

    public void render(WorldRenderContext context) {
        this.entries.forEach(Functions.withArgument(Entry::render, context, this));
        this.renderEffects(context);
    }

    public void tick(class_638 world) {
        this.entries.removeIf(Entry::shouldRemove);
        this.entries.forEach(Entry::tick);
        if (world.method_8510() % 10L == 0L) {
            this.chargePositions.clear();
        }
        this.chargePositions.values().forEach(ChargeLinePositions::clearPositions);
    }

    private Collection<ChargeLinePositions> getChargePositions(class_1309 entity) {
        Collection mapValue = this.chargePositions.get((Object)entity);
        if (!mapValue.isEmpty()) {
            return mapValue;
        }
        ArrayList<ChargeLinePositions> computedValue = new ArrayList<ChargeLinePositions>();
        class_238 box = BoxUtil.multiplyBox(entity.method_5829(), 0.75);
        for (int i = 0; i < 6; ++i) {
            class_243 initialPos = BoxUtil.randomPos(box);
            class_243 finalPos = BoxUtil.randomPos(box);
            computedValue.add(new ChargeLinePositions(initialPos, finalPos, (class_1297)entity));
        }
        this.chargePositions.putAll((Object)entity, computedValue);
        return computedValue;
    }

    private void renderQuickenAura(WorldRenderContext context, class_1309 entity) {
        if (!ClientConfig.getEffectRenderType().allowsSpecialEffects()) {
            return;
        }
        this.getChargePositions(entity).forEach(clp -> {
            Color color = clp.computeColorIfAbsent(() -> Math.random() < 0.5 ? Colors.ELECTRO : Colors.DENDRO);
            this.renderChargeLine(context, (ChargeLinePositions)clp, (class_1297)entity, color, Colors.PHYSICAL);
        });
    }

    private void renderElectroAura(WorldRenderContext context, class_1309 entity) {
        if (!ClientConfig.getEffectRenderType().allowsNormalEffects()) {
            return;
        }
        this.getChargePositions(entity).forEach(clp -> this.renderChargeLine(context, (ChargeLinePositions)clp, (class_1297)entity, Colors.ELECTRO, Colors.PHYSICAL));
    }

    private void renderEffects(WorldRenderContext context) {
        for (class_1297 entity : context.world().method_18112()) {
            class_1309 livingEntity;
            if (!(entity instanceof class_1309) || !SpecialEffectsRenderer.shouldRender((class_1297)(livingEntity = (class_1309)entity))) continue;
            ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)livingEntity);
            if (component.hasElementalApplication(Element.QUICKEN)) {
                this.renderQuickenAura(context, livingEntity);
                continue;
            }
            if (!component.hasElementalApplication(Element.ELECTRO)) continue;
            this.renderElectroAura(context, livingEntity);
        }
    }

    private void renderChargeLine(WorldRenderContext context, ChargeLinePositions clp, class_1297 entity, Color outerColor, Color innerColor) {
        class_243 initialPos = clp.getInitialPos(entity);
        this.renderChargeLine(context, initialPos, clp.generatePositions(this, entity), outerColor, innerColor);
    }

    private void renderChargeLine(WorldRenderContext context, class_243 initialPos, class_243 finalPos, Color outerColor, Color innerColor) {
        List<class_243> positions = this.generatePositions(class_243.field_1353, initialPos.method_1020(finalPos));
        class_243 randomVec = class_243.field_1353;
        for (int i = 0; i < positions.size(); ++i) {
            randomVec = new class_243(RANDOM.method_43058() - 0.5, RANDOM.method_43058() - 0.5, RANDOM.method_43058() - 0.5);
            positions.set(i, positions.get(i).method_1019(randomVec));
        }
        positions.add(0, class_243.field_1353);
        positions.add(finalPos.method_1020(initialPos));
        this.renderChargeLine(context, initialPos, positions, outerColor, innerColor);
    }

    private void renderChargeLine(WorldRenderContext context, class_243 origin, List<class_243> positions, Color outerColor, Color innerColor) {
        class_243 normal;
        class_243 end;
        class_243 start;
        int i;
        class_4184 camera = context.camera();
        class_243 camPos = camera.method_19326();
        class_4587 matrices = new class_4587();
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0f));
        matrices.method_22904(origin.field_1352 - camPos.field_1352, origin.field_1351 - camPos.field_1351, origin.field_1350 - camPos.field_1350);
        class_289 tesselator = class_289.method_1348();
        Matrix4f posMat = matrices.method_23760().method_23761();
        class_4587.class_4665 entry = matrices.method_23760();
        class_287 buffer = tesselator.method_60827(class_293.class_5596.field_27377, class_290.field_29337);
        for (i = 1; i < positions.size(); ++i) {
            start = positions.get(i - 1);
            end = positions.get(i);
            normal = end.method_1029();
            buffer.method_22918(posMat, (float)start.field_1352, (float)start.field_1351, (float)start.field_1350).method_39415(outerColor.asARGB()).method_60831(entry, (float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350);
            buffer.method_22918(posMat, (float)end.field_1352, (float)end.field_1351, (float)end.field_1350).method_39415(outerColor.asARGB()).method_60831(entry, (float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350);
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.setShader(class_757::method_34535);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.lineWidth((float)6.0f);
        class_286.method_43433((class_9801)buffer.method_60800());
        buffer = tesselator.method_60827(class_293.class_5596.field_27377, class_290.field_29337);
        for (i = 1; i < positions.size(); ++i) {
            start = positions.get(i - 1);
            end = positions.get(i);
            normal = end.method_1029();
            buffer.method_22918(posMat, (float)start.field_1352, (float)start.field_1351, (float)start.field_1350).method_39415(innerColor.asARGB()).method_60831(entry, (float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350);
            buffer.method_22918(posMat, (float)end.field_1352, (float)end.field_1351, (float)end.field_1350).method_39415(innerColor.asARGB()).method_60831(entry, (float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350);
        }
        RenderSystem.lineWidth((float)2.0f);
        class_286.method_43433((class_9801)buffer.method_60800());
        matrices.method_22909();
    }

    private List<class_243> generatePositions(class_243 initialPos, class_243 finalPos) {
        class_243 norm = initialPos.method_1020(finalPos);
        double length = norm.method_1033();
        int n = Math.max(1, this.poisson(1.5 * length));
        ArrayList<Double> doubles = new ArrayList<Double>();
        for (int i = 0; i < n; ++i) {
            doubles.add(RANDOM.method_43058());
        }
        return doubles.stream().sorted().map(t -> initialPos.method_1019(norm.method_1021(t.doubleValue())).method_1019(new class_243(RANDOM.method_43058() - 0.5, RANDOM.method_43058() - 0.5, RANDOM.method_43058() - 0.5))).collect(Collectors.toList());
    }

    private int poisson(double lambda) {
        double L = Math.exp(-lambda);
        int k = 0;
        double p = 1.0;
        do {
            ++k;
        } while ((p *= RANDOM.method_43058()) > L);
        return k - 1;
    }

    @Environment(value=EnvType.CLIENT)
    private static class ElectroChargedEffect
    extends Entry {
        private final long time;
        private final class_1297 mainEntity;
        private final List<class_1297> otherEntities;
        private final Map<class_1297, StoredElectroChargedPositions> positionMap = new HashMap<class_1297, StoredElectroChargedPositions>();

        private ElectroChargedEffect(class_1297 mainEntity, List<class_1297> otherEntities) {
            this.time = class_310.method_1551().field_1687.method_8510();
            this.mainEntity = mainEntity;
            this.otherEntities = otherEntities;
        }

        @Override
        boolean shouldRemove() {
            return !this.mainEntity.method_5805() || this.otherEntities.isEmpty() || class_310.method_1551().field_1687.method_8510() > this.time + 10L;
        }

        @Override
        void render(WorldRenderContext context, SpecialEffectsRenderer renderer) {
            double gradientStep = class_3532.method_15363((float)class_3532.method_37960((float)((float)(class_310.method_1551().field_1687.method_8510() - this.time) + context.tickCounter().method_60637(false)), (float)0.0f, (float)10.0f), (float)0.0f, (float)1.0f);
            Color outerColor = Color.gradientStep(Colors.ELECTRO, Colors.HYDRO, gradientStep, Ease.IN_QUART);
            Color innerColor = Colors.PHYSICAL;
            for (class_1297 other : this.otherEntities) {
                if (other == this.mainEntity) continue;
                StoredElectroChargedPositions entry = this.positionMap.computeIfAbsent(other, o -> new StoredElectroChargedPositions(this.mainEntity, other));
                renderer.renderChargeLine(context, this.entityPos(this.mainEntity), entry.generatePositions(renderer), outerColor, innerColor);
            }
        }

        @Override
        void tick() {
            super.tick();
            this.positionMap.values().forEach(StoredElectroChargedPositions::tick);
        }

        private class_243 entityPos(class_1297 entity) {
            return entity.method_19538().method_1031(0.0, (double)entity.method_17682() * 0.5, 0.0);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class ChargeLinePositions {
        private final class_243 initialPos;
        private final class_243 finalPos;
        @Nullable
        private List<class_243> positions = null;
        @Nullable
        private Color color = null;

        private ChargeLinePositions(class_243 initialPos, class_243 finalPos, class_1297 relativeTo) {
            class_243 entityPos = relativeTo.method_19538();
            this.initialPos = initialPos.method_1020(entityPos);
            this.finalPos = finalPos.method_1020(entityPos);
        }

        private class_243 getInitialPos(class_1297 relativeTo) {
            return this.initialPos.method_1019(relativeTo.method_19538());
        }

        private List<class_243> generatePositions(SpecialEffectsRenderer renderer, class_1297 relativeTo) {
            if (this.positions != null) {
                return this.positions;
            }
            class_243 entityPos = relativeTo.method_19538();
            List<class_243> positions = renderer.generatePositions(class_243.field_1353, this.initialPos.method_1020(this.finalPos));
            class_243 randomVec = class_243.field_1353;
            for (int i = 0; i < positions.size(); ++i) {
                randomVec = new class_243(RANDOM.method_43058() - 0.5, RANDOM.method_43058() - 0.5, RANDOM.method_43058() - 0.5);
                positions.set(i, positions.get(i).method_1019(randomVec));
            }
            positions.add(0, class_243.field_1353);
            positions.add(this.finalPos.method_1020(this.initialPos));
            this.positions = positions;
            return positions.stream().map(Functions.withArgument(class_243::method_1019, entityPos)).toList();
        }

        private void clearPositions() {
            this.positions = null;
        }

        @Nullable
        private Color getColor() {
            return this.color;
        }

        private Color computeColorIfAbsent(Supplier<Color> ifAbsent) {
            this.color = JavaScriptUtil.nullishCoalesing(this.color, ifAbsent.get());
            return this.color;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class StoredElectroChargedPositions {
        private final class_1297 mainEntity;
        private final class_1297 targetEntity;
        private class_243 prevMainEntityPos;
        private class_243 prevTargetEntityPos;
        @Nullable
        private List<class_243> positions = null;

        private StoredElectroChargedPositions(class_1297 mainEntity, class_1297 targetEntity) {
            this.mainEntity = mainEntity;
            this.targetEntity = targetEntity;
            this.prevMainEntityPos = this.entityPos(mainEntity);
            this.prevTargetEntityPos = this.entityPos(targetEntity);
        }

        private void tick() {
            this.positions = null;
        }

        private boolean shouldPositionsPersist() {
            return this.entityPos(this.mainEntity).equals((Object)this.prevMainEntityPos) && this.entityPos(this.targetEntity).equals((Object)this.prevTargetEntityPos);
        }

        private List<class_243> generatePositions(SpecialEffectsRenderer renderer) {
            if (this.positions != null && this.shouldPositionsPersist()) {
                return this.positions;
            }
            class_243 initialPos = this.prevMainEntityPos = this.entityPos(this.mainEntity);
            class_243 finalPos = this.prevTargetEntityPos = this.entityPos(this.targetEntity);
            List<class_243> positions = renderer.generatePositions(class_243.field_1353, initialPos.method_1020(finalPos));
            class_243 randomVec = class_243.field_1353;
            for (int i = 0; i < positions.size(); ++i) {
                randomVec = new class_243(RANDOM.method_43058() - 0.5, RANDOM.method_43058() - 0.5, RANDOM.method_43058() - 0.5);
                positions.set(i, positions.get(i).method_1019(randomVec));
            }
            positions.add(0, class_243.field_1353);
            positions.add(finalPos.method_1020(initialPos));
            this.positions = positions;
            return positions;
        }

        private class_243 entityPos(class_1297 entity) {
            return entity.method_19538().method_1031(0.0, (double)entity.method_17682() * 0.5, 0.0);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static abstract class Entry {
        private Entry() {
        }

        abstract boolean shouldRemove();

        abstract void render(WorldRenderContext var1, SpecialEffectsRenderer var2);

        void tick() {
        }
    }
}

