package io.github.xrickastley.sevenelements.renderer.entity;

import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.entity.DendroCoreEntity;
import io.github.xrickastley.sevenelements.renderer.entity.model.DendroCoreEntityModel;
import io.github.xrickastley.sevenelements.util.Ease;
import io.github.xrickastley.sevenelements.util.MathHelper2;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_922;

public class DendroCoreEntityRenderer extends class_922<DendroCoreEntity, class_583<DendroCoreEntity>> {
	public DendroCoreEntityRenderer(class_5617.class_5618 context) {
		super(
			context,
			DendroCoreEntityRenderer.createModel(context),
			0.5f
		);
	}

	private static class_583<DendroCoreEntity> createModel(class_5617.class_5618 context) {
		return new DendroCoreEntityModel(context.method_32167(DendroCoreEntityModel.MODEL_LAYER));
	}

	public class_2960 getTexture(DendroCoreEntity entity) {
		return SevenElements.identifier("textures/entity/dendro_core/dendro_core.png");
	}

	@Override
	public void render(DendroCoreEntity dendroCore, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i) {
		this.field_4672 = 0f;
		this.field_4673 = 0f;

		super.method_4054(dendroCore, f, g, matrixStack, vertexConsumerProvider, i);
	}

	@Override
	protected void scale(DendroCoreEntity dendroCore, class_4587 matrixStack, float delta) {
		final double explodeProgress = Ease.IN_QUAD.applyLerp(MathHelper2.endOffset(dendroCore.field_6012 + delta, 2, 0, 120), 0, 1.5);
		final float scale = !dendroCore.isHyperbloom()
			? 0.5f + (float) (explodeProgress * 5)
			: 0.35f;

		matrixStack.method_46416(0, 0, 0);
		matrixStack.method_22905(scale, scale, scale);
	}

	@Override
	protected void renderLabelIfPresent(DendroCoreEntity entity, class_2561 text, class_4587 matrices, class_4597 vertexConsumers, int light) {}
}
