/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements;

import com.mojang.brigadier.CommandDispatcher;
import io.github.xrickastley.sevenelements.command.BossBarCommand;
import io.github.xrickastley.sevenelements.command.DamageCommand;
import io.github.xrickastley.sevenelements.command.ElementArgumentType;
import io.github.xrickastley.sevenelements.command.ElementCommand;
import io.github.xrickastley.sevenelements.command.InternalCooldownTagType;
import io.github.xrickastley.sevenelements.element.InternalCooldownType;
import io.github.xrickastley.sevenelements.factory.SevenElementsFactories;
import io.github.xrickastley.sevenelements.factory.SevenElementsGameRules;
import io.github.xrickastley.sevenelements.registry.SevenElementsPayloadsS2C;
import io.github.xrickastley.sevenelements.registry.SevenElementsRegistryKeys;
import io.github.xrickastley.sevenelements.registry.dynamic.DynamicRegistries;
import io.github.xrickastley.sevenelements.registry.dynamic.DynamicRegistryLoadEvents;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SevenElements
implements ModInitializer {
    public static final String MOD_ID = "seven-elements";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"seven-elements");

    public void onInitialize() {
        LOGGER.info("Seven Elements Initialized!");
        SevenElementsFactories.registerAll();
        SevenElementsPayloadsS2C.register();
        CommandRegistrationCallback.EVENT.register(SevenElements::onCommandRegistration);
        DynamicRegistryLoadEvents.BEFORE_LOAD.register(SevenElements::onBeforeRegistryLoad);
        DynamicRegistries.registerIdentified(InternalCooldownType.class, SevenElementsRegistryKeys.INTERNAL_COOLDOWN_TYPE, InternalCooldownType.Builder.CODEC, InternalCooldownType.CODEC, InternalCooldownType.Builder::getInstance);
        DynamicRegistries.addUnmodifiableEntries(SevenElementsRegistryKeys.INTERNAL_COOLDOWN_TYPE, InternalCooldownType.getPreloadedInstances());
        ArgumentTypeRegistry.registerArgumentType((class_2960)SevenElements.identifier("element"), ElementArgumentType.class, (class_2314)class_2319.method_41999(ElementArgumentType::new));
        ArgumentTypeRegistry.registerArgumentType((class_2960)SevenElements.identifier("internal_cooldown_tag"), InternalCooldownTagType.class, (class_2314)class_2319.method_41999(InternalCooldownTagType::new));
    }

    public static class_2960 identifier(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static <T> class_5321<T> registryKey(class_5321<? extends class_2378<T>> registry, String path) {
        return class_5321.method_29179(registry, (class_2960)SevenElements.identifier(path));
    }

    public static Logger sublogger() {
        String className = Thread.currentThread().getStackTrace()[2].getClassName();
        return SevenElements.sublogger(className.substring(className.lastIndexOf(".") + 1));
    }

    public static Logger sublogger(String sublogger) {
        return LoggerFactory.getLogger((String)("seven-elements/" + sublogger));
    }

    public static Logger sublogger(Class<?> sublogger) {
        return LoggerFactory.getLogger((String)("seven-elements/" + sublogger.getSimpleName()));
    }

    public static Logger sublogger(Object sublogger) {
        return LoggerFactory.getLogger((String)("seven-elements/" + sublogger.getClass().getSimpleName()));
    }

    public static float getLevelMultiplier(class_1297 entity) {
        float f;
        class_1937 class_19372 = entity.method_73183();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            f = SevenElements.getLevelMultiplier(world);
        } else {
            f = 5.0f;
        }
        return f;
    }

    public static float getLevelMultiplier(class_3218 world) {
        return ((Double)world.method_64395().method_76185(SevenElementsGameRules.LEVEL_MULTIPLIER)).floatValue();
    }

    private static void onCommandRegistration(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        BossBarCommand.register(dispatcher);
        ElementCommand.register(dispatcher, registryAccess);
        DamageCommand.register(dispatcher, registryAccess);
    }

    private static void onBeforeRegistryLoad(DynamicRegistryLoadEvents.RegistryContext<?> registryContext) {
        @Nullable DynamicRegistryLoadEvents.RegistryContext<InternalCooldownType> context = registryContext.asKey(SevenElementsRegistryKeys.INTERNAL_COOLDOWN_TYPE);
        if (context == null) {
            return;
        }
        class_2378<InternalCooldownType> registry = context.registry();
        if (registry.method_10250(InternalCooldownType.DEFAULT.getId())) {
            return;
        }
        InternalCooldownType.onBeforeRegistryLoad(registry);
    }
}

