/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.component;

import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.component.ElementComponentImpl;
import io.github.xrickastley.sevenelements.component.ElementalInfusionComponent;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementHolder;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReaction;
import io.github.xrickastley.sevenelements.util.Array;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;
import io.github.xrickastley.sevenelements.util.Functions;
import io.github.xrickastley.sevenelements.util.JavaScriptUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1676;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_6862;
import net.minecraft.class_8110;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistry;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public interface ElementComponent
extends AutoSyncedComponent,
CommonTickingComponent {
    public static final ComponentKey<ElementComponent> KEY = ComponentRegistry.getOrCreate((class_2960)SevenElements.identifier("elements"), ElementComponent.class);

    public static <T extends class_1309> void denyElementsFor(Class<T> entityClass) {
        ElementComponentImpl.DENIED_ENTITIES.add((Class)ClassInstanceUtil.cast(entityClass));
    }

    public static ElementalDamageSource applyElementalInfusions(class_1282 source, class_1309 target) {
        ElementalDamageSource eds;
        if (source instanceof ElementalDamageSource && ((eds = (ElementalDamageSource)source).getElementalApplication().getElement() != Element.PHYSICAL || !eds.shouldInfuse())) {
            return eds;
        }
        ElementalDamageSource infusion = (ElementalDamageSource)JavaScriptUtil.nullishCoalesingFn(Functions.map(Functions.supplier(ElementalInfusionComponent::applyToDamageSource, source, target), ElementComponent::get), Functions.map(Functions.supplier(ElementComponent::attemptDamageTypeInfusions, source, target), ElementComponent::get), Functions.map(Functions.supplier(ElementComponent::attemptEntityDamageInfusions, source, target), ElementComponent::get), Functions.map(Functions.supplier(ElementComponent::attemptProjectileInfusions, source, target), ElementComponent::get));
        return infusion != null ? infusion : ElementalDamageSource.of(source, target);
    }

    private static Optional<ElementalDamageSource> attemptEntityDamageInfusions(class_1282 source, class_1309 target) {
        class_1297 class_12972 = source.method_5529();
        if (!(class_12972 instanceof class_1309)) {
            return Optional.empty();
        }
        class_1309 attacker = (class_1309)class_12972;
        for (Map.Entry entry : ElementComponentImpl.ENTITY_TYPE_ELEMENT_MAP.entrySet()) {
            if (!attacker.method_5864().method_20210((class_6862)entry.getKey())) continue;
            return Optional.of(new ElementalDamageSource(source, ElementalApplications.gaugeUnits(target, (Element)((Object)entry.getValue()), 1.0), InternalCooldownContext.ofDefault(attacker, "seven-elements:mob_attack")));
        }
        return Optional.empty();
    }

    private static Optional<ElementalDamageSource> attemptDamageTypeInfusions(class_1282 source, class_1309 target) {
        for (Map.Entry<class_6862<class_8110>, Element> entry : ElementComponentImpl.DAMAGE_TYPE_ELEMENT_MAP.entrySet()) {
            if (!source.method_48789(entry.getKey())) continue;
            return Optional.of(new ElementalDamageSource(source, ElementalApplications.gaugeUnits(target, entry.getValue(), 1.0), InternalCooldownContext.ofDefault(target, "seven-elements:damage_infusion")));
        }
        return Optional.empty();
    }

    private static Optional<ElementalDamageSource> attemptProjectileInfusions(class_1282 source, class_1309 target) {
        Optional optional;
        if (source.method_60489()) {
            return Optional.empty();
        }
        class_1297 class_12972 = source.method_5526();
        if (class_12972 instanceof class_1676) {
            class_1676 projectile = (class_1676)class_12972;
            optional = projectile.sevenelements$attemptInfusion(source, (class_1297)target);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Nullable
    private static <T> T get(Optional<T> optional) {
        return optional.orElse(null);
    }

    public class_1309 getOwner();

    public ElementHolder getElementHolder(Element var1);

    public class_3545<ElementalReaction, Long> getLastReaction();

    default public boolean hasLastReaction() {
        return this.getLastReaction().method_15442() != null;
    }

    default public boolean hasValidLastReaction() {
        return this.hasLastReaction() && (Long)this.getLastReaction().method_15441() + 10L >= this.getOwner().method_73183().method_75260();
    }

    public boolean isElectroChargedOnCD();

    public boolean isBurningOnCD();

    public void resetElectroChargedCD();

    public void resetBurningCD();

    public void setElectroChargedOrigin(@Nullable class_1309 var1);

    public void setBurningOrigin(@Nullable class_1309 var1);

    @Nullable
    public class_1309 getElectroChargedOrigin();

    @Nullable
    public class_1309 getBurningOrigin();

    public double getFreezeDecayTimeModifier();

    default public void setOrRetainElectroChargedOrigin(@Nullable class_1309 origin) {
        this.setElectroChargedOrigin(origin != null ? origin : this.getElectroChargedOrigin());
    }

    default public void setOrRetainBurningOrigin(@Nullable class_1309 origin) {
        this.setBurningOrigin(origin != null ? origin : this.getBurningOrigin());
    }

    public void setCrystallizeShield(Element var1, double var2);

    @Nullable
    public class_3545<Element, Double> getCrystallizeShield();

    public float reduceCrystallizeShield(class_1282 var1, float var2);

    public boolean reducedCrystallizeShield();

    default public boolean canApplyElement(Element element, InternalCooldownContext icdContext) {
        return this.canApplyElement(element, icdContext, false);
    }

    public boolean canApplyElement(Element var1, InternalCooldownContext var2, boolean var3);

    default public List<ElementalReaction> addElementalApplication(Element element, InternalCooldownContext icdContext, double gaugeUnits) {
        boolean isAura = this.getAppliedElements().isEmpty();
        return this.addElementalApplication(ElementalApplications.gaugeUnits(this.getOwner(), element, gaugeUnits, isAura), icdContext);
    }

    default public List<ElementalReaction> addElementalApplication(Element element, InternalCooldownContext icdContext, double gaugeUnits, double duration) {
        return this.addElementalApplication(ElementalApplications.duration(this.getOwner(), element, gaugeUnits, duration), icdContext);
    }

    public List<ElementalReaction> addElementalApplication(ElementalApplication var1, InternalCooldownContext var2);

    default public boolean hasElementalApplication(Element element) {
        return this.getElementHolder(element).hasElementalApplication();
    }

    default public double reduceElementalApplication(Element element, double gaugeUnits) {
        return Optional.ofNullable(this.getElementalApplication(element)).map(application -> application.reduceGauge(gaugeUnits)).orElse(-1.0);
    }

    default public ElementalApplication getElementalApplication(Element element) {
        return this.getElementHolder(element).getElementalApplication();
    }

    public Array<ElementalApplication> getAppliedElements();

    public List<ElementalReaction> applyFromDamageSource(ElementalDamageSource var1);

    public Optional<Integer> getHighestElementPriority();

    public Array<ElementalApplication> getPrioritizedElements();

    public static void sync(class_1297 entity) {
        if (entity.method_73183().method_8608()) {
            return;
        }
        KEY.sync((Object)entity);
    }
}

