/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.element;

import com.mojang.serialization.Codec;
import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.events.ElementEvents;
import io.github.xrickastley.sevenelements.exception.ElementalApplicationOperationException;
import io.github.xrickastley.sevenelements.util.JavaScriptUtil;
import io.github.xrickastley.sevenelements.util.TextHelper;
import io.github.xrickastley.sevenelements.util.ViewHelper;
import java.text.DecimalFormat;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_11368;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_4844;
import org.jetbrains.annotations.Nullable;

public final class GaugeUnitElementalApplication
extends ElementalApplication {
    private double decayRate;

    GaugeUnitElementalApplication(class_1309 entity, Element element, UUID uuid, double gaugeUnits, boolean isAura) {
        super(ElementalApplication.Type.GAUGE_UNIT, entity, element, uuid, gaugeUnits, isAura);
        this.decayRate = GaugeUnitElementalApplication.getDefaultDecayRate(gaugeUnits);
        if (this.isAura && element.hasAuraTax()) {
            this.currentGauge *= 0.8;
        }
    }

    static ElementalApplication fromData(class_1309 entity, class_11368 view, long syncedAt) {
        Element element = ViewHelper.get(view, "Element", Element.CODEC);
        UUID uuid = (UUID)ViewHelper.get(view, "UUID", class_4844.field_40825);
        double gaugeUnits = (Double)ViewHelper.get(view, "GaugeUnits", Codec.doubleRange((double)0.0, (double)Double.MAX_VALUE));
        double currentGauge = (Double)ViewHelper.get(view, "CurrentGauge", Codec.doubleRange((double)0.0, (double)Double.MAX_VALUE));
        boolean isAura = (Boolean)ViewHelper.get(view, "IsAura", Codec.BOOL);
        GaugeUnitElementalApplication application = new GaugeUnitElementalApplication(entity, element, uuid, gaugeUnits, isAura);
        double syncedGaugeDeduction = (double)Math.max(entity.method_73183().method_75260() - syncedAt, 0L) * application.getDecayRate();
        application.currentGauge = class_3532.method_15350((double)(currentGauge - syncedGaugeDeduction), (double)0.0, (double)application.gaugeUnits);
        application.appliedAt = (Long)ViewHelper.get(view, "AppliedAt", Codec.LONG);
        return application;
    }

    private static double getDefaultDecayRate(double gaugeUnits) {
        double decayRate = 35.0 / (4.0 * gaugeUnits) + 3.125;
        double decayRateTicks = decayRate / 0.05;
        return 1.0 / decayRateTicks;
    }

    private double getDecayRate() {
        @Nullable Function<ElementalApplication, Number> customDecayRate = this.element.getCustomDecayRate();
        return customDecayRate == null ? this.getDefaultDecayRate() : customDecayRate.apply(this).doubleValue();
    }

    @Override
    protected double getDefaultDecayRate() {
        return this.decayRate;
    }

    @Override
    public int getRemainingTicks() {
        double decayRate = 1.0 / this.getDecayRate();
        return (int)(decayRate * this.currentGauge);
    }

    @Override
    public class_2561 getText(@Nullable DecimalFormat gaugeFormat, @Nullable DecimalFormat durationFormat) {
        gaugeFormat = JavaScriptUtil.nullishCoalesing(gaugeFormat, GAUGE_UNIT_FORMAT);
        return TextHelper.color(class_2561.method_43469((String)"formats.seven-elements.elemental_application.gauge_unit", (Object[])new Object[]{gaugeFormat.format(this.currentGauge), this.element.getString()}), this.element.getDamageColor());
    }

    @Override
    public boolean isEmpty() {
        return this.currentGauge <= 0.0;
    }

    @Override
    public void tick() {
        super.tick();
        this.currentGauge -= this.getDecayRate();
    }

    @Override
    public void reapply(ElementalApplication application) {
        if (application.element != this.element) {
            throw new ElementalApplicationOperationException(ElementalApplicationOperationException.Operation.REAPPLICATION_INVALID_ELEMENT, this, application);
        }
        if (application.type != this.type || !(application instanceof GaugeUnitElementalApplication)) {
            throw new ElementalApplicationOperationException(ElementalApplicationOperationException.Operation.REAPPLICATION_INVALID_TYPES, this, application);
        }
        GaugeUnitElementalApplication guApp = (GaugeUnitElementalApplication)application;
        this.currentGauge = this.gaugeUnits = Math.max(this.gaugeUnits, guApp.gaugeUnits);
        double d = this.decayRate = this.element.hasDecayInheritance() ? Math.min(this.decayRate, guApp.decayRate) : guApp.decayRate;
        if (this.isAura) {
            this.currentGauge *= 0.8;
        }
        ((ElementEvents.ElementReapplied)ElementEvents.REAPPLIED.invoker()).onElementReapplied(this.element, this);
        ElementComponent.sync((class_1297)this.entity);
    }

    @Override
    public ElementalApplication asAura() {
        return new GaugeUnitElementalApplication(this.entity, this.element, UUID.randomUUID(), this.gaugeUnits, true);
    }

    @Override
    public ElementalApplication asNonAura() {
        return new GaugeUnitElementalApplication(this.entity, this.element, UUID.randomUUID(), this.gaugeUnits, false);
    }

    public String toString() {
        return String.format("%s@%s[type=GAUGE_UNIT, element=%s, gaugeUnits=%2f, currentGauge=%.2f]", this.getClass().getSimpleName(), Integer.toHexString(this.hashCode()), this.getElement().toString(), this.getGaugeUnits(), this.getCurrentGauge());
    }
}

