package io.github.xrickastley.sevenelements.advancement.criterion;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2073;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.util.Functions;

public class ElementalInfusionCriterion extends class_4558<ElementalInfusionCriterion.Conditions> {
	public Codec<io.github.xrickastley.sevenelements.advancement.criterion.ElementalInfusionCriterion.Conditions> method_54937() {
		return io.github.xrickastley.sevenelements.advancement.criterion.ElementalInfusionCriterion.Conditions.CODEC;
	}

	public void trigger(class_3222 player, class_1799 stack, Element infused) {
		this.method_22510(player, Functions.withArgument(io.github.xrickastley.sevenelements.advancement.criterion.ElementalInfusionCriterion.Conditions::requirementsMet, stack, infused));
	}

	public record Conditions(Optional<class_5258> player, Optional<class_2073> item, Optional<Element> element) implements class_4558.class_8788 {
		public static final Codec<ElementalInfusionCriterion.Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group(
			class_5258.field_47234.optionalFieldOf("player").forGetter(io.github.xrickastley.sevenelements.advancement.criterion.ElementalInfusionCriterion.Conditions::comp_2029),
			class_2073.field_45754.optionalFieldOf("item").forGetter(io.github.xrickastley.sevenelements.advancement.criterion.ElementalInfusionCriterion.Conditions::item),
			Element.CODEC.optionalFieldOf("element").forGetter(io.github.xrickastley.sevenelements.advancement.criterion.ElementalInfusionCriterion.Conditions::element)
		).apply(instance, io.github.xrickastley.sevenelements.advancement.criterion.ElementalInfusionCriterion.Conditions::new));

		public boolean requirementsMet(class_1799 stack, Element infused) {
			return (element.isEmpty() || element.get() == infused)
				&& (item.isEmpty() || item.get().method_8970(stack));
		}
	}
}
