package io.github.xrickastley.sevenelements.element.reaction;

import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.registry.SevenElementsItemTags;
import io.github.xrickastley.sevenelements.util.TextHelper;
import net.minecraft.class_1309;
import net.minecraft.class_7923;

public final class HeavyShatterElementalReaction extends AbstractShatterElementalReaction {
	HeavyShatterElementalReaction() {
		super(
			new Settings("Shatter", SevenElements.identifier("shatter_heavy"), TextHelper.reaction("reaction.seven-elements.shatter", "#cfffff"))
				.setReactionCoefficient(0)
				.setAuraElement(Element.FREEZE)
				.setTriggeringElement(Element.PHYSICAL, 0)
		);
	}

	@Override
	public boolean isTriggerable(class_1309 entity) {
		return ElementComponent.KEY.get(entity).hasElementalApplication(Element.FREEZE)
			&& entity.sevenelements$getPlannedAttacker() != null
			&& entity.sevenelements$getPlannedAttacker() instanceof final class_1309 attacker
			&& entity.sevenelements$getPlannedDamageSource() != null
			&& entity.sevenelements$getPlannedDamageSource().method_60489()
			&& class_7923.field_41178
				.method_47983(attacker.method_6047().method_7909())
				.method_40220(SevenElementsItemTags.HEAVY_WEAPON);
	}
}
