package io.github.xrickastley.sevenelements.component;

import io.github.xrickastley.sevenelements.effect.SevenElementsStatusEffects;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_7225;

public final class FrozenEffectComponentImpl implements FrozenEffectComponent {
	private final class_1309 owner;
	private boolean isFrozen = false;
	private boolean hadNoAi = false;
	private class_4050 forcePose = class_4050.field_18076;
	private float forceHeadYaw = 0.0f;
	private float forceBodyYaw = 0.0f;
	private float forcePitch = 0.0f;
	private float forceLimbAngle = 0.0f;
	private float forceLimbDistance = 0.0f;
	private int ticksFrozen = 0;

	public FrozenEffectComponentImpl(class_1309 owner) {
		this.owner = owner;
	}

	@Override
	public void readFromNbt(class_2487 tag, class_7225.class_7874 registry) {
		this.isFrozen = tag.method_10577("IsFrozen");
		this.hadNoAi = tag.method_10577("HadNoAi");
		this.forcePose = class_4050.valueOf(tag.method_10558("ForcePose"));
		this.forceHeadYaw = tag.method_10583("ForceHeadYaw");
		this.forceBodyYaw = tag.method_10583("ForceBodyYaw");
		this.forcePitch = tag.method_10583("ForcePitch");
		this.forceLimbAngle = tag.method_10583("ForceLimbAngle");
		this.forceLimbDistance = tag.method_10583("ForceLimbDistance");
		this.ticksFrozen = tag.method_10550("TicksFrozen");
	}

	@Override
	public void writeToNbt(class_2487 tag, class_7225.class_7874 registry) {
		tag.method_10556("IsFrozen", this.isFrozen);
		tag.method_10556("HadNoAi", this.hadNoAi);
		tag.method_10582("ForcePose", this.forcePose.toString());
		tag.method_10548("ForceHeadYaw", this.forceHeadYaw);
		tag.method_10548("ForceBodyYaw", this.forceBodyYaw);
		tag.method_10548("ForcePitch", this.forcePitch);
		tag.method_10548("ForceLimbAngle", this.forceLimbAngle);
		tag.method_10548("ForceLimbDistance", this.forceLimbDistance);
		tag.method_10569("TicksFrozen", this.ticksFrozen);
	}

	@Override
	public void clientTick() {
		if (!this.owner.method_6059(SevenElementsStatusEffects.FROZEN) && this.isFrozen)
			this.unfreeze();

		if (!this.isFrozen()) return;

		owner.method_18380(this.forcePose);
		owner.method_5847(this.forceBodyYaw);
		owner.method_5636(this.forceBodyYaw);
		owner.method_36457(this.forcePitch);
	}

	@Override
	public void serverTick() {
		if (!this.owner.method_6059(SevenElementsStatusEffects.FROZEN) && this.isFrozen)
			this.unfreeze();
	}

	public boolean isFrozen() {
		return this.isFrozen;
	}

	public class_4050 getForcePose() {
		return this.forcePose;
	}

	public float getForceHeadYaw() {
		return this.forceHeadYaw;
	}

	public float getForceBodyYaw() {
		return this.forceBodyYaw;
	}

	public float getForcePitch() {
		return this.forcePitch;
	}

	public float getForceLimbAngle() {
		return this.forceLimbAngle;
	}

	public float getForceLimbDistance() {
		return this.forceLimbDistance;
	}

	public void freeze() {
		if (this.isFrozen) return;

		this.isFrozen = true;
		this.hadNoAi = owner instanceof final class_1308 mob && mob.method_5987();
		this.forcePose = owner.method_18376();
		this.forceHeadYaw = owner.method_5791();
		this.forceBodyYaw = owner.method_43078();
		this.forcePitch = owner.method_36455();
		this.forceLimbAngle = class_3532.method_15344(owner.method_59922(), 0, 0.5f);
		this.forceLimbDistance = class_3532.method_15344(owner.method_59922(), -0.5f, 0.5f);
		this.ticksFrozen = owner.method_32312();

		owner.method_5803(true);

		if (owner instanceof final class_1308 mob) mob.method_5977(true);

		FrozenEffectComponent.sync(owner);
	}

	public void unfreeze() {
		if (!this.isFrozen) return;

		this.isFrozen = false;

		owner.method_5803(false);

		if (owner instanceof final class_1308 mob) mob.method_5977(this.hadNoAi);

		owner.method_32317(this.ticksFrozen);

		FrozenEffectComponent.sync(owner);
	}
}
