package io.github.xrickastley.sevenelements.element.reaction;

import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1927.class_4179;
import net.minecraft.class_2398;
import net.minecraft.class_2664;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_5362;
import org.jetbrains.annotations.Nullable;

import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.factory.SevenElementsGameRules;
import io.github.xrickastley.sevenelements.registry.SevenElementsDamageTypes;
import io.github.xrickastley.sevenelements.util.NonEntityDamagingExplosion;
import io.github.xrickastley.sevenelements.util.TextHelper;

public class OverloadedElementalReaction extends ElementalReaction {
	OverloadedElementalReaction() {
		super(
			new Settings("Overloaded", SevenElements.identifier("overloaded"), TextHelper.reaction("reaction.seven-elements.overloaded", "#fc7fa4"))
				.setReactionCoefficient(1.0)
				.setAuraElement(Element.PYRO, 2)
				.setTriggeringElement(Element.ELECTRO, 3)
				.reversable(true)
		);
	}

	@Override
	protected void onReaction(class_1309 entity, ElementalApplication auraElement, ElementalApplication triggeringElement, double reducedGauge, @Nullable class_1309 origin) {
		if (!(entity.method_37908() instanceof final class_3218 world)) return;

		final float power = 3;

		final NonEntityDamagingExplosion explosion = new NonEntityDamagingExplosion(
			world,
			null,
			new class_5362(),
			entity.method_19538(),
			power,
			true,
			world.method_64395().method_8355(SevenElementsGameRules.OVERLOADED_EXPLOSIONS_DAMAGE_BLOCKS)
				? class_4179.field_18687
				: class_4179.field_40878
		);

		explosion.explode();
		explosion
			.getAffectedEntities()
			.forEach(e -> damage(e, origin));

		for (class_3222 serverPlayerEntity : world.method_18456()) {
			if (serverPlayerEntity.method_5707(entity.method_19538()) >= 4096.0) continue;

			serverPlayerEntity.field_13987.method_14364(
				new class_2664(
					entity.method_19538(),
					Optional.ofNullable(explosion.getKnockbackByPlayer().get(serverPlayerEntity)),
					explosion.isSmall() ? class_2398.field_11236 : class_2398.field_11221,
					class_3417.field_15152
				)
			);
		}
	}

	private void damage(class_1297 entity, @Nullable class_1297 origin) {
		if (!(entity instanceof final class_1309 living)) return;

		if (!(entity.method_37908() instanceof final class_3218 world)) return;

		final ElementalApplication application = ElementalApplications.gaugeUnits(living, Element.PYRO, 0);
		final ElementalDamageSource source = new ElementalDamageSource(
			entity
				.method_48923()
				.method_48796(SevenElementsDamageTypes.OVERLOADED, origin),
			application,
			InternalCooldownContext.ofNone(entity)
		).shouldApplyDMGBonus(false);

		float amount = ElementalReaction.getReactionDamage(entity, 2.75);

		if (entity == origin) amount = 0;

		entity.method_64397(world, source, amount);
	}
}
