package io.github.xrickastley.sevenelements.networking;

import java.util.ArrayList;
import java.util.List;

import io.github.xrickastley.sevenelements.SevenElementsClient;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReaction;
import io.github.xrickastley.sevenelements.entity.CrystallizeShardEntity.SyncCrystallizeShardTypeS2CPayload;
import io.github.xrickastley.sevenelements.entity.CrystallizeShardEntity;
import io.github.xrickastley.sevenelements.entity.DendroCoreEntity.SyncDendroCoreS2CPayload;
import io.github.xrickastley.sevenelements.entity.DendroCoreEntity;
import io.github.xrickastley.sevenelements.gui.screen.ingame.ElementalInfusionScreen;
import io.github.xrickastley.sevenelements.renderer.WorldTextRenderer.DamageText;
import io.github.xrickastley.sevenelements.renderer.WorldTextRenderer.ReactionText;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;
import io.github.xrickastley.sevenelements.util.ClientConfig;
import io.github.xrickastley.sevenelements.util.Color;
import io.github.xrickastley.sevenelements.util.Colors;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking.Context;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_8710;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;

public class SevenElementsPacketsS2C {
	private static final List<PayloadHandler<? extends class_8710>> HANDLERS = new ArrayList<>();
	private static boolean registered = false;

	public static void register() {
		ClientPlayConnectionEvents.INIT.register(SevenElementsPacketsS2C::onPlayInit);
	}

	public static void registerHandler(final PayloadHandler<? extends class_8710> handler) {
		if (registered) throw new IllegalStateException("All ClientPlayConnectionEvents.INIT handlers have already been registered!");

		SevenElementsPacketsS2C.HANDLERS.add(handler);
	}

	private static void registerHandlers() {
		registered = true;

		for (final PayloadHandler<? extends class_8710> handler : SevenElementsPacketsS2C.HANDLERS)
			ClientPlayNetworking.registerGlobalReceiver(handler.getPayloadId(), ClassInstanceUtil.cast(handler));
	}

	private static void onPlayInit(class_634 handler, class_310 client) {
		ClientPlayNetworking.registerGlobalReceiver(ShowElementalReactionS2CPayload.ID, SevenElementsPacketsS2C::onElementalReactionShow);
		ClientPlayNetworking.registerGlobalReceiver(ShowElementalDamageS2CPayload.ID, SevenElementsPacketsS2C::onElementalDamageShow);
		ClientPlayNetworking.registerGlobalReceiver(SyncDendroCoreS2CPayload.ID, SevenElementsPacketsS2C::onSyncDendroCoreAge);
		ClientPlayNetworking.registerGlobalReceiver(SyncCrystallizeShardTypeS2CPayload.ID, SevenElementsPacketsS2C::onSyncCrystallizeShardElement);
		ClientPlayNetworking.registerGlobalReceiver(FinishElementalInfusionS2CPayload.ID, SevenElementsPacketsS2C::onFinishElementalInfusion);

		SevenElementsPacketsS2C.registerHandlers();
	}

	private static void onElementalReactionShow(ShowElementalReactionS2CPayload payload, Context context) {
		final class_243 pos = payload.pos();
		final ElementalReaction reaction = payload.reaction();

		if (reaction == null || reaction.getText() == null) return;

		SevenElementsClient.WORLD_TEXT_RENDERER.addEntry(
			new ReactionText(pos.field_1352, pos.field_1351, pos.field_1350, Colors.PHYSICAL, reaction.getText())
		);
	}

	private static void onElementalDamageShow(ShowElementalDamageS2CPayload payload, Context context) {
		final ClientConfig config = ClientConfig.get();

		if (!config.rendering.text.showDamageText) return;

		final class_243 pos = payload.pos();
		final Color color = payload.element() != null && payload.element().hasDamageColor()
			? payload.element().getDamageColor()
			: Colors.PHYSICAL;
		final float amount = config.developer.genshinDamageLim
			? Math.min(payload.amount(), 20_000_000)
			: payload.amount();

		if (amount == Float.MAX_VALUE) return;

		SevenElementsClient.WORLD_TEXT_RENDERER.addEntry(
			new DamageText(pos.field_1352, pos.field_1351, pos.field_1350, color, amount, payload.crit() ? config.rendering.text.critDMGScale : config.rendering.text.normalDMGScale)
		);
	}

	private static void onSyncDendroCoreAge(SyncDendroCoreS2CPayload payload, Context context) {
		final class_1937 world = class_310
			.method_1551()
			.field_1724
			.method_37908();

		final class_1297 entity = world.method_8469(payload.entityId());

		if (!(entity instanceof final DendroCoreEntity dendroCore)) return;

		dendroCore.syncFromPayload(payload);
	}

	private static void onSyncCrystallizeShardElement(SyncCrystallizeShardTypeS2CPayload payload, Context context) {
		final class_1937 world = class_310
			.method_1551()
			.field_1724
			.method_37908();

		final class_1297 entity = world.method_8469(payload.entityId());

		if (!(entity instanceof final CrystallizeShardEntity crystallizeShard)) return;

		crystallizeShard.syncFromPacket(payload);
	}

	private static void onFinishElementalInfusion(FinishElementalInfusionS2CPayload payload, Context context) {
		final class_1657 playerEntity = context.player();
		final class_1703 screenHandler = playerEntity.field_7512;
		final class_437 currentScreen = context.client().field_1755;

		if (screenHandler != null
			&& screenHandler.field_7763 == payload.syncId()
			&& currentScreen instanceof final ElementalInfusionScreen screen
		) {
			screen.finishElementalInfusion(payload);
		}
	}
}
