package io.github.xrickastley.sevenelements.renderer.entity;

import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_922;
import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.entity.CrystallizeShardEntity;
import io.github.xrickastley.sevenelements.renderer.entity.model.CrystallizeShardEntityModel;
import io.github.xrickastley.sevenelements.renderer.entity.state.CrystallizeShardEntityState;

public class CrystallizeShardEntityRenderer extends class_922<CrystallizeShardEntity, CrystallizeShardEntityState, CrystallizeShardEntityModel> {
	private static final Set<Element> VALID_ELEMENTS = Set.of(Element.PYRO, Element.HYDRO, Element.ELECTRO, Element.CRYO, Element.GEO);

	public CrystallizeShardEntityRenderer(class_5617.class_5618 context) {
		super(
			context,
			CrystallizeShardEntityRenderer.createModel(context),
			0.5f
		);
	}

	private static CrystallizeShardEntityModel createModel(class_5617.class_5618 context) {
		return new CrystallizeShardEntityModel(context.method_32167(CrystallizeShardEntityModel.MODEL_LAYER));
	}

	@Override
	public class_2960 getTexture(CrystallizeShardEntityState state) {
		return state.element != null && VALID_ELEMENTS.contains(state.element)
			? SevenElements.identifier("textures/entity/crystallize_shard/crystallize_shard_" + state.element.toString().toLowerCase() + ".png")
			: SevenElements.identifier("textures/entity/crystallize_shard/crystallize_shard.png");
	}

	@Override
	public CrystallizeShardEntityState method_55269() {
		return new CrystallizeShardEntityState();
	}

	@Override
	public void updateRenderState(CrystallizeShardEntity crystallizeShard, CrystallizeShardEntityState state, float f) {
		super.method_62355(crystallizeShard, state, f);

		state.element = crystallizeShard.getElement();
		state.idleAnimationState = crystallizeShard.idleAnimationState;
	}

	@Override
	public void render(CrystallizeShardEntityState state, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i) {
		if (state.element == null) return;

		this.field_4672 = 0f;
		this.field_4673 = 0f;

		super.method_4054(state, matrixStack, vertexConsumerProvider, i);
	}

	@Override
	protected void renderLabelIfPresent(CrystallizeShardEntityState state, class_2561 text, class_4587 matrices, class_4597 vertexConsumers, int light) {}
}
