/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.element;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.xrickastley.sevenelements.element.ElementHolder;
import io.github.xrickastley.sevenelements.element.InternalCooldown;
import io.github.xrickastley.sevenelements.element.InternalCooldownHolder;
import io.github.xrickastley.sevenelements.element.InternalCooldownTag;
import io.github.xrickastley.sevenelements.element.InternalCooldownType;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public final class InternalCooldownContext {
    private static final UUID FORCE_HANDLER_UUID = UUID.fromString("301286c7-09eb-4ce0-a11a-94303bbc795e");
    @Nullable
    private final class_1309 origin;
    private final InternalCooldownTag tag;
    private final InternalCooldownType type;
    private final boolean force;

    public InternalCooldownContext(@Nullable class_1309 origin, InternalCooldownTag tag, InternalCooldownType type) {
        this(origin, tag, type, false);
    }

    private InternalCooldownContext(@Nullable class_1309 origin, InternalCooldownTag tag, InternalCooldownType type, boolean force) {
        this.origin = origin;
        this.tag = tag;
        this.type = type;
        this.force = force;
    }

    public static InternalCooldownContext ofNone() {
        return new InternalCooldownContext(null, InternalCooldownTag.NONE, InternalCooldownType.NONE);
    }

    public static InternalCooldownContext ofNone(@Nullable class_1297 origin) {
        return InternalCooldownContext.ofNone(ClassInstanceUtil.castOrNull(origin, class_1309.class));
    }

    public static InternalCooldownContext ofNone(@Nullable class_1309 origin) {
        return new InternalCooldownContext(origin, InternalCooldownTag.NONE, InternalCooldownType.DEFAULT);
    }

    public static InternalCooldownContext ofDefault(@Nullable class_1297 origin, @Nullable String tag) {
        return InternalCooldownContext.ofDefault(ClassInstanceUtil.castOrNull(origin, class_1309.class), InternalCooldownTag.of(tag));
    }

    public static InternalCooldownContext ofDefault(@Nullable class_1297 origin, InternalCooldownTag tag) {
        return InternalCooldownContext.ofDefault(ClassInstanceUtil.castOrNull(origin, class_1309.class), tag);
    }

    public static InternalCooldownContext ofDefault(@Nullable class_1309 origin, @Nullable String tag) {
        return InternalCooldownContext.ofDefault(origin, InternalCooldownTag.of(tag));
    }

    public static InternalCooldownContext ofDefault(@Nullable class_1309 origin, InternalCooldownTag tag) {
        return new InternalCooldownContext(origin, tag, InternalCooldownType.DEFAULT);
    }

    public static InternalCooldownContext ofType(@Nullable class_1297 origin, @Nullable String tag, InternalCooldownType type) {
        return InternalCooldownContext.ofType(ClassInstanceUtil.castOrNull(origin, class_1309.class), InternalCooldownTag.of(tag), type);
    }

    public static InternalCooldownContext ofType(@Nullable class_1297 origin, InternalCooldownTag tag, InternalCooldownType type) {
        return InternalCooldownContext.ofType(ClassInstanceUtil.castOrNull(origin, class_1309.class), tag, type);
    }

    public static InternalCooldownContext ofType(@Nullable class_1309 origin, @Nullable String tag, InternalCooldownType type) {
        return InternalCooldownContext.ofType(origin, InternalCooldownTag.of(tag), type);
    }

    public static InternalCooldownContext ofType(@Nullable class_1309 origin, InternalCooldownTag tag, InternalCooldownType type) {
        return new InternalCooldownContext(origin, tag, type);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    private UUID getUuid() {
        return this.origin == null && this.force ? FORCE_HANDLER_UUID : ClassInstanceUtil.mapOrNull(this.origin, class_1297::method_5667);
    }

    public InternalCooldownContext withOrigin(@Nullable class_1309 origin) {
        return new InternalCooldownContext(origin, this.tag, this.type);
    }

    public InternalCooldownContext forced() {
        return new InternalCooldownContext(this.origin, this.tag, this.type, true);
    }

    public boolean hasInternalCooldown() {
        return this.getUuid() != null;
    }

    @Nullable
    public InternalCooldown getInternalCooldown(ElementHolder holder) {
        UUID uuid = this.getUuid();
        return uuid != null ? this.getInternalCooldown(holder.internalCooldowns.computeIfAbsent(uuid, e -> new InternalCooldownHolder(holder.getOwner()))) : null;
    }

    public InternalCooldown getInternalCooldown(InternalCooldownHolder holder) {
        return holder.getInternalCooldown(this.tag, this.type);
    }

    public boolean hasOrigin() {
        return this.origin != null;
    }

    @Nullable
    public class_1309 getOrigin() {
        return this.origin;
    }

    public String toString() {
        return String.format("InternalCooldownContext@%s[origin=%s,tag=%s,type=%s]", Integer.toHexString(this.hashCode()), this.origin == null ? "null" : this.origin, this.tag, this.type);
    }

    public static final class Builder {
        public static final Codec<Builder> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)InternalCooldownTag.CODEC.fieldOf("tag").forGetter(i -> i.tag), (App)InternalCooldownType.REGISTRY_CODEC.optionalFieldOf("type", (Object)class_6880.method_40223((Object)InternalCooldownType.DEFAULT)).forGetter(i -> class_6880.method_40223((Object)i.type))).apply((Applicative)instance, Builder::new));
        private InternalCooldownTag tag;
        private InternalCooldownType type;

        private Builder() {
        }

        private Builder(InternalCooldownTag tag, class_6880<InternalCooldownType> type) {
            this.tag = tag;
            this.type = (InternalCooldownType)type.comp_349();
        }

        public static Builder ofNone() {
            return new Builder().setTag(InternalCooldownTag.NONE).setType(InternalCooldownType.NONE);
        }

        public static InternalCooldownTag getTag(Builder builder) {
            return builder.tag;
        }

        public static InternalCooldownType getType(Builder builder) {
            return builder.type;
        }

        public Builder setTag(InternalCooldownTag tag) {
            this.tag = tag;
            return this;
        }

        public Builder setType(InternalCooldownType type) {
            this.type = type;
            return this;
        }

        public InternalCooldownContext build(@Nullable class_1309 origin) {
            Objects.requireNonNull(this.tag);
            Objects.requireNonNull(this.type);
            return InternalCooldownContext.ofType(origin, this.tag, this.type);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Builder)) {
                return false;
            }
            Builder builder = (Builder)obj;
            return Objects.equals(this.type, builder.type) && Objects.equals(this.tag, builder.tag);
        }
    }
}

