/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.util;

import io.github.xrickastley.sevenelements.renderer.SevenElementsRenderLayer;
import io.github.xrickastley.sevenelements.renderer.SevenElementsRenderPipelines;
import io.github.xrickastley.sevenelements.renderer.SevenElementsRenderer;
import io.github.xrickastley.sevenelements.util.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_9799;
import org.apache.commons.lang3.function.TriConsumer;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class CircleRenderer {
    private final List<Renderable> dataArray = new ArrayList<Renderable>();
    private double scaleFactor = 1.0 / class_310.method_1551().method_22683().method_4495();
    private double x;
    private double y;
    private double z;

    public CircleRenderer(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public CircleRenderer add(double radius, double percentFilled, Color color) {
        this.dataArray.add(new Circle(radius, percentFilled, color.asARGB()));
        return this;
    }

    public CircleRenderer add(double radius, double percentFilled, int color) {
        this.dataArray.add(new Circle(radius, percentFilled, color));
        return this;
    }

    public CircleRenderer addOutline(double radius, double length, double percentFilled, Color color) {
        this.dataArray.add(new CircleOutline(radius, length, percentFilled, color.asARGB()));
        return this;
    }

    public CircleRenderer addOutline(double radius, double length, double percentFilled, int color) {
        this.dataArray.add(new CircleOutline(radius, length, percentFilled, color));
        return this;
    }

    public void draw(Matrix4f posMatrix) {
        class_243 origin = new class_243(this.x, this.y, 0.0).method_1021(this.scaleFactor);
        this.dataArray.forEach(CircleRenderer.args(Renderable::render, origin, posMatrix));
        this.dataArray.clear();
    }

    private static <T, I, J> Consumer<T> args(TriConsumer<T, I, J> consumer, I i, J j) {
        return t -> consumer.accept(t, i, j);
    }

    @Environment(value=EnvType.CLIENT)
    private class Circle
    implements Renderable {
        private static final class_9799 allocator = SevenElementsRenderer.createAllocator(SevenElementsRenderLayer.getTriangleFan().method_22722());
        private static class_287 buffer;
        protected double radius;
        protected double percentFilled;
        protected int color;

        protected Circle(double radius, double percentFilled, int color) {
            this.radius = radius;
            this.percentFilled = percentFilled;
            this.color = color;
        }

        @Override
        public void render(class_243 origin, Matrix4f posMatrix) {
            buffer = SevenElementsRenderer.createBuffer(buffer, allocator, SevenElementsRenderPipelines.TRIANGLE_FAN);
            buffer.method_22918(posMatrix, (float)origin.method_10216(), (float)origin.method_10214(), (float)origin.method_10215()).method_39415(this.color);
            double subdivisions = Math.ceil(360.0 * this.percentFilled);
            int i = 0;
            while ((double)i <= subdivisions) {
                float x = (float)(origin.method_10216() + Math.cos((double)i * (Math.PI / 180) + 1.5707963267948966) * (this.radius * CircleRenderer.this.scaleFactor));
                float y = (float)(origin.method_10214() - Math.sin((double)i * (Math.PI / 180) + 1.5707963267948966) * (this.radius * CircleRenderer.this.scaleFactor));
                buffer.method_22918(posMatrix, x, y, (float)CircleRenderer.this.z).method_39415(this.color);
                ++i;
            }
            SevenElementsRenderLayer.getTriangleFan().method_60895(buffer.method_60800());
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class CircleOutline
    extends Circle {
        private static final class_9799 allocator = SevenElementsRenderer.createAllocator(SevenElementsRenderLayer.getTriangleStrip().method_22722());
        private static class_287 buffer;
        protected double length;

        protected CircleOutline(double radius, double length, double percentFilled, int color) {
            super(radius, percentFilled, color);
            this.length = length;
        }

        @Override
        public void render(class_243 origin, Matrix4f posMatrix) {
            buffer = SevenElementsRenderer.createBuffer(buffer, allocator, SevenElementsRenderPipelines.TRIANGLE_STRIP);
            float innerRadius = (float)(this.radius * CircleRenderer.this.scaleFactor);
            float totalRadius = (float)((this.radius + this.length) * CircleRenderer.this.scaleFactor);
            float x = (float)(origin.method_10216() + Math.cos(1.5707963267948966) * (double)innerRadius);
            float y = (float)(origin.method_10214() - Math.sin(1.5707963267948966) * (double)innerRadius);
            buffer.method_22918(posMatrix, x, y, (float)origin.method_10215()).method_39415(this.color);
            double subdivisions = Math.ceil(360.0 * this.percentFilled);
            int i = 0;
            while ((double)i <= subdivisions) {
                float outerX = (float)(origin.method_10216() + Math.cos((double)i * (Math.PI / 180) + 1.5707963267948966) * (double)totalRadius);
                float outerY = (float)(origin.method_10214() - Math.sin((double)i * (Math.PI / 180) + 1.5707963267948966) * (double)totalRadius);
                buffer.method_22918(posMatrix, outerX, outerY, (float)origin.method_10215()).method_39415(this.color);
                float innerX = (float)(origin.method_10216() + Math.cos((double)i * (Math.PI / 180) + 1.5707963267948966) * (double)innerRadius);
                float innerY = (float)(origin.method_10214() - Math.sin((double)i * (Math.PI / 180) + 1.5707963267948966) * (double)innerRadius);
                buffer.method_22918(posMatrix, innerX, innerY, (float)origin.method_10215()).method_39415(this.color);
                ++i;
            }
            SevenElementsRenderLayer.getTriangleFan().method_60895(buffer.method_60800());
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static interface Renderable {
        public void render(class_243 var1, Matrix4f var2);
    }
}

