package io.github.xrickastley.sevenelements.component;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import dev.onyxstudios.cca.api.v3.item.ItemComponent;

public final class ElementalInfusionComponent extends ItemComponent {
	private static final Logger LOGGER = SevenElements.sublogger();

	public static final ComponentKey<ElementalInfusionComponent> KEY = ComponentRegistry.getOrCreate(SevenElements.identifier("elemental_infusion"), ElementalInfusionComponent.class);

	public ElementalInfusionComponent(class_1799 stack) {
		super(stack);
	}

	public static Optional<ElementalDamageSource> applyToDamageSource(class_1282 source, class_1297 target) {
		try {
			if (source.method_48790() || !(target instanceof final class_1309 livingTarget) || !(source.method_5529() instanceof final class_1309 attacker)) return Optional.empty();

			final ElementalInfusionComponent component = ElementalInfusionComponent.get(attacker.method_6047());

			if (component == null || !component.hasElementalInfusion()) return Optional.empty();

			return Optional.of(
				new ElementalDamageSource(
					source,
					component.getElementalInfusion(livingTarget),
					component.internalCooldown().build(attacker)
				)
			);
		} catch (Exception e) {
			return Optional.empty();
		}
	}

	public static void applyInfusion(class_1799 stack, ElementalApplication.Builder applicationBuilder, InternalCooldownContext.Builder icdBuilder) {
		final ElementalInfusionComponent component = ElementalInfusionComponent.get(stack);

		if (component == null) return;

		component.setElementalInfusion(applicationBuilder);
		component.setInternalCooldown(icdBuilder);

		return;
	}

	public static boolean removeInfusion(class_1799 stack) {
		if (!ElementalInfusionComponent.hasInfusion(stack)) return false;

		final ElementalInfusionComponent component = ElementalInfusionComponent.get(stack);

		if (component == null) return false;

		component.remove("elemental_infusion");
		component.remove("internal_cooldown");

		return true;
	}

	public static boolean hasInfusion(class_1799 stack) {
		return Optional
			.of(ElementalInfusionComponent.get(stack))
			.map(ElementalInfusionComponent::hasElementalInfusion)
			.orElse(false);
	}

	public static @Nullable ElementalInfusionComponent get(class_1799 stack) {
		return ElementalInfusionComponent.KEY.maybeGet(stack).orElse(null);
	}

	public @Nullable ElementalApplication.Builder elementalInfusion() {
		return this.hasElementalInfusion()
			? ElementalApplication.Builder.CODEC
				.parse(class_2509.field_11560, this.getCompound("elemental_infusion"))
				.resultOrPartial(LOGGER::error)
				.orElseThrow()
			: null;
	}

	public @Nullable InternalCooldownContext.Builder internalCooldown() {
		return this.hasTag("internal_cooldown", class_2520.field_33260)
			? InternalCooldownContext.Builder.CODEC
				.parse(class_2509.field_11560, this.getCompound("internal_cooldown"))
				.resultOrPartial(LOGGER::error)
				.orElseThrow()
			: null;
	}

	public boolean hasElementalInfusion() {
		return this.hasTag("elemental_infusion", class_2520.field_33260);
	}

	public @Nullable ElementalApplication getElementalInfusion(class_1309 target) {
		return this.hasElementalInfusion()
			? this.elementalInfusion().build(target)
			: null;
	}

	public @Nullable Element getElement() {
		return this.hasElementalInfusion()
			? this.elementalInfusion().getElement()
			: null;
	}

	public double getGaugeUnits() {
		return this.hasElementalInfusion()
			? this.getGaugeUnits()
			: 0;
	}

	public void setElementalInfusion(ElementalApplication.Builder builder) {
		this.putCompound(
			"elemental_infusion",
			(class_2487) ElementalApplication.Builder.CODEC
				.encodeStart(class_2509.field_11560, builder)
				.resultOrPartial(LOGGER::error)
				.orElseThrow()
		);
	}

	public void setInternalCooldown(InternalCooldownContext.Builder builder) {
		this.putCompound(
			"internal_cooldown",
			(class_2487) InternalCooldownContext.Builder.CODEC
				.encodeStart(class_2509.field_11560, builder)
				.resultOrPartial(LOGGER::error)
				.orElseThrow()
		);
	}

	public Optional<ElementalDamageSource> apply(class_1282 source, class_1297 target) {
		if (!(target instanceof final class_1309 livingTarget) || !(source.method_5529() instanceof final class_1309 attacker) || !this.hasElementalInfusion())
			return Optional.empty();

		return Optional.of(
			new ElementalDamageSource(
				source,
				this.getElementalInfusion(livingTarget),
				this.internalCooldown().build(attacker)
			)
		);
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) return true;

		if (!(obj instanceof final ElementalInfusionComponent component)) return false;

		return Objects.equals(this.elementalInfusion(), component.elementalInfusion())
			&& Objects.equals(this.internalCooldown(), component.internalCooldown());
	}
}
