package io.github.xrickastley.sevenelements.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;

import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import io.github.xrickastley.sevenelements.effect.SevenElementsStatusEffects;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.element.InternalCooldownType;
import io.github.xrickastley.sevenelements.entity.CrystallizeShardEntity;
import io.github.xrickastley.sevenelements.factory.SevenElementsGameRules;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;

// Prioritized since Frozen **MUST** disable movement.
@Mixin(value = class_1297.class, priority = Integer.MIN_VALUE)
public abstract class EntityMixin {
	@Shadow
	public abstract class_1937 getWorld();

	@ModifyReturnValue(
		method = "handleAttack",
		at = @At("RETURN")
	)
	private boolean noAttackIfAttackerFrozen(boolean original, @Local(argsOnly = true) class_1297 attacker) {
		final boolean attackerHasFrozenEffect = attacker instanceof final class_1309 livingAttacker
			&& livingAttacker.method_6059(SevenElementsStatusEffects.FROZEN);

		return original || attackerHasFrozenEffect;
	}

	@ModifyVariable(
		method = "setVelocity(Lnet/minecraft/util/math/Vec3d;)V",
		at = @At("HEAD"),
		argsOnly = true,
		ordinal = 0
	)
	private class_243 frozenPreventsMovement(class_243 original) {
		final @Nullable class_1309 entity = ClassInstanceUtil.castOrNull(this, class_1309.class);

		return entity != null && entity.method_6059(SevenElementsStatusEffects.FROZEN)
			? new class_243(0, original.field_1351, 0)
			: original;
	}

	@Final
	@ModifyArg(
		method = "onStruckByLightning",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/entity/Entity;damage(Lnet/minecraft/entity/damage/DamageSource;F)Z",
			ordinal = 0
		)
	)
	private class_1282 applyElectroOnLightning(class_1282 source) {
		return (class_1297)(Object) this instanceof final class_1309 entity && this.getWorld().method_8450().method_8355(SevenElementsGameRules.ELECTRO_FROM_LIGHTNING)
			? new ElementalDamageSource(source, ElementalApplications.gaugeUnits(entity, Element.ELECTRO, 2.0), InternalCooldownContext.ofType(null, "seven-elements:natural_environment", InternalCooldownType.INTERVAL_ONLY).forced())
			: source;
	}

	@Inject(
		method = "setPos",
		at = @At("TAIL")
	)
	private void syncOnPosChangeIfCrystallizeShard(double x, double y, double z, CallbackInfo ci) {
		final CrystallizeShardEntity crystallizeShard = ClassInstanceUtil.castOrNull(this, CrystallizeShardEntity.class);

		if (crystallizeShard == null) return;

		// Sync after pos change, that way PlayerTracking.lookup properly works.
		crystallizeShard.syncToPlayers();
	}
}
