package io.github.xrickastley.sevenelements.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;

import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import io.github.xrickastley.sevenelements.component.ElementalInfusionComponent;
import net.minecraft.class_1799;
import net.minecraft.class_3803;

@Debug(export = true)
@Mixin(class_3803.class)
public class GrindstoneScreenHandlerMixin {
	@Inject(
		method = "grind",
		at = @At("RETURN")
	)
	private void includeElementInGrind(class_1799 item, int damage, int amount, CallbackInfoReturnable<class_1799> cir) {
		ElementalInfusionComponent.removeInfusion(item);
	}

	@WrapOperation(
		method = "updateResult",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/item/ItemStack;hasEnchantments()Z"
		)
	)
	private boolean checkForElementInResult(class_1799 instance, Operation<Boolean> original) {
		return original.call(instance) || ElementalInfusionComponent.hasInfusion(instance);
	}

	@ModifyVariable(
		method = "updateResult",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/inventory/Inventory;setStack(ILnet/minecraft/item/ItemStack;)V",
			ordinal = 3
		),
		ordinal = 1
	)
	private class_1799 checkForElementInStacks(class_1799 original, @Local(ordinal = 0) class_1799 firstInput, @Local(ordinal = 1) class_1799 secondInput) {
		return (class_1799.method_7984(firstInput, secondInput) || !(firstInput.method_7960() == secondInput.method_7960()))
			&& (firstInput.method_7947() + secondInput.method_7947() <= 64)
			? new class_1799(firstInput.method_7909(), firstInput.method_7947() + secondInput.method_7947())
			: original;
	}
}
