package io.github.xrickastley.sevenelements.mixin;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.authlib.GameProfile;

import java.util.ArrayList;
import java.util.List;

import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.component.ElementComponentImpl;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import io.github.xrickastley.sevenelements.entity.DendroCoreEntity;
import io.github.xrickastley.sevenelements.factory.SevenElementsSoundEvents;
import io.github.xrickastley.sevenelements.interfaces.DamageSourceWrapper;
import io.github.xrickastley.sevenelements.interfaces.IPlayerEntity;
import io.github.xrickastley.sevenelements.networking.ShowElementalDamageS2CPayload;
import io.github.xrickastley.sevenelements.util.BoxUtil;

import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;

@Debug(export = true)
@Mixin(class_1657.class)
public abstract class PlayerEntityMixin
	extends class_1309
	implements IPlayerEntity
{
	public PlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
		super(class_1299.field_6097, world);
		throw new AssertionError();
	}

	@Unique
	private float sevenelements$subdamage;

	@Unique
	private List<class_1282> sevenelements$critDamageSources = new ArrayList<>();

	@Unique
	@Override
	public boolean sevenelements$isCrit(class_1282 source) {
		return this.sevenelements$critDamageSources != null && this.sevenelements$critDamageSources.contains(source);
	}

	@ModifyVariable(
		method = "applyDamage",
		at = @At(
			value = "INVOKE_ASSIGN",
			target = "Lnet/minecraft/entity/player/PlayerEntity;modifyAppliedDamage(Lnet/minecraft/entity/damage/DamageSource;F)F"
		),
		ordinal = 0,
		argsOnly = true
	)
	private float applyCrystallizeShield(float amount, @Local(argsOnly = true) class_1282 source) {
		final ElementComponent component = ElementComponent.KEY.get(this);
		final float finalAmount = amount - component.reduceCrystallizeShield(source, amount);

		if (finalAmount < amount)
			this.method_37908().method_8396(null, this.method_24515(), SevenElementsSoundEvents.CRYSTALLIZE_SHIELD_HIT, class_3419.field_15248, 1.0f, 1.0f);

		if (finalAmount <= 0) this.sevenelements$setBlockedByCrystallizeShield(true);

		return finalAmount;
	}

	// why are there two separate knockbacks :sob:
	@Definition(id = "i", local = @Local(type = int.class, ordinal = 0))
	@Expression("i > 0")
	@ModifyExpressionValue(
		method = "attack",
		at = @At("MIXINEXTRAS:EXPRESSION")
	)
	private boolean preventKnockbackIfCrystallize(boolean original, @Local(argsOnly = true) class_1297 entity) {
		if (!(entity instanceof final class_1309 livingEntity)) return original;

		final ElementComponent component = ElementComponent.KEY.get(livingEntity);

		return original && !component.reducedCrystallizeShield();
	}

	@ModifyArg(
		method = "attack",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/entity/Entity;damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"
		),
		index = 0
	)
	private class_1282 checkForCritMain(class_1282 source, @Local(ordinal = 2) boolean crit) {
		if (sevenelements$critDamageSources == null) sevenelements$critDamageSources = new ArrayList<>();

		if (crit) {
			sevenelements$critDamageSources.add(
				source instanceof final DamageSourceWrapper wrapper ? wrapper.getOriginalSource() : source
			);
		}

		return source;
	}

	@ModifyArg(
		method = "attack",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/entity/LivingEntity;damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"
		),
		index = 0
	)
	private class_1282 checkForCritSweep(class_1282 source, @Local(ordinal = 2) boolean crit) {
		if (sevenelements$critDamageSources == null) sevenelements$critDamageSources = new ArrayList<>();

		if (crit) sevenelements$critDamageSources.add(source);

		return source;
	}

	@Inject(
		method = "tick",
		at = @At("HEAD")
	)
	private void removeCritDS(CallbackInfo ci) {
		if (sevenelements$critDamageSources != null)
			sevenelements$critDamageSources.clear();
		else
			sevenelements$critDamageSources = new ArrayList<>();
	}

	@Inject(
		method = "applyDamage",
		at = @At("TAIL")
	)
	private void damageHandlers_elements(final class_1282 source, float amount, CallbackInfo ci) {
		this.sevenelements$triggerDendroCoreReactions(source);

		if (!source.sevenelements$displayDamage()) return;

		final ElementalDamageSource eds = ElementComponentImpl.resolve(source, this);

		sevenelements$subdamage += amount;

		if (sevenelements$subdamage < 1) return;

		final float extra = sevenelements$subdamage - (float) Math.floor(sevenelements$subdamage);

		sevenelements$subdamage = (float) Math.floor(sevenelements$subdamage);

		final class_1937 world = this.method_37908();

		if (world.field_9236 || !(world instanceof class_3218)) return;

		final class_238 boundingBox = this.method_5829();

		final double x = this.method_23317() + (boundingBox.method_17939() * 1.25 * Math.random());
		final double y = this.method_23318() + (boundingBox.method_17940() * 0.50 * Math.random()) + 0.50;
		final double z = this.method_23321() + (boundingBox.method_17941() * 1.25 * Math.random());
		final class_243 pos = new class_243(x, y, z);
		final boolean isCrit = eds.getOriginalSource() != null
			&& source.method_5529() instanceof final class_1657 player
			&& ((IPlayerEntity) player).sevenelements$isCrit(eds.getOriginalSource());

		final Element element = eds.getElementalApplication().getElement();
		final ShowElementalDamageS2CPayload showElementalDMGPacket = new ShowElementalDamageS2CPayload(pos, element, sevenelements$subdamage, isCrit);

		sevenelements$subdamage = extra;

		for (final class_3222 player : PlayerLookup.tracking(this)) {
			if (player.method_5628() == this.method_5628()) return;

			ServerPlayNetworking.send(player, showElementalDMGPacket);
		}
	}

	@Unique
	private void sevenelements$triggerDendroCoreReactions(final class_1282 source) {
		if (!(source instanceof final ElementalDamageSource eds)) return;

		final Element element = eds.getElementalApplication().getElement();

		if (element != Element.PYRO && element != Element.ELECTRO) return;

		this.method_37908()
			.method_8390(DendroCoreEntity.class, BoxUtil.multiplyBox(this.method_5829(), 2), dc -> true)
			.forEach(dc -> dc.method_5643(source, 1));
	}
}
