package io.github.xrickastley.sevenelements.networking;

import com.mojang.serialization.Codec;

import org.slf4j.Logger;

import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;

import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

// Custom backport of Minecraft 1.20.5's CustomPayload class.
public interface SevenElementsPayload extends FabricPacket {
	public Id<? extends SevenElementsPayload> getId();

	public Codec<? extends SevenElementsPayload> getCodec();

	@Override
	default PacketType<?> getType() {
		final Logger LOGGER = SevenElements.sublogger(SevenElementsPayload.class);

		return PacketType.create(
			this.getId().id(),
			buf -> this.getCodec().parse(class_2509.field_11560, buf.method_10798()).resultOrPartial(LOGGER::error).orElseThrow()
		);
	}

	default void write(class_2540 buf) {
		final Logger LOGGER = SevenElements.sublogger(SevenElementsPayload.class);

		buf.method_10794(
			(class_2487) this.getCodec()
				.encodeStart(class_2509.field_11560, ClassInstanceUtil.cast(this))
				.resultOrPartial(LOGGER::error)
				.orElseThrow()
		);
	}

	public record Id<T extends SevenElementsPayload>(class_2960 id, Codec<T> codec) {
		public PacketType<T> Type() {
			final Logger LOGGER = SevenElements.sublogger(SevenElementsPayload.class);

			return PacketType.create(
				this.id(),
				buf -> this.codec().parse(class_2509.field_11560, buf.method_10798()).resultOrPartial(LOGGER::error).orElseThrow()
			);
		}
	}
}
