package io.github.xrickastley.sevenelements.particle;

import java.util.Locale;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2540;
import net.minecraft.class_3532;
import net.minecraft.class_5253;
import net.minecraft.class_7923;
import com.mojang.serialization.MapCodec;

import io.github.xrickastley.sevenelements.util.dynamic.SevenElementsCodecs;

public class EntityEffectParticleEffect implements class_2394 {
	private final class_2396<EntityEffectParticleEffect> type;
	private final int color;

	public static MapCodec<EntityEffectParticleEffect> createCodec(class_2396<EntityEffectParticleEffect> type) {
		return SevenElementsCodecs.ARGB
			.xmap(color -> new EntityEffectParticleEffect(type, color), effect -> effect.color)
			.fieldOf("color");
	}

	private EntityEffectParticleEffect(class_2396<EntityEffectParticleEffect> type, int color) {
		this.type = type;
		this.color = color;
	}

	public void method_10294(class_2540 buf) {
		buf.method_10804(this.color);
	}

	public String method_10293() {
		return String.format(Locale.ROOT, "%s %d", class_7923.field_41180.method_10221(this.method_10295()), this.color);
	}

	@Override
	public class_2396<EntityEffectParticleEffect> method_10295() {
		return this.type;
	}

	public float getRed() {
		return class_5253.class_5254.method_27765(this.color) / 255.0F;
	}

	public float getGreen() {
		return class_5253.class_5254.method_27766(this.color) / 255.0F;
	}

	public float getBlue() {
		return class_5253.class_5254.method_27767(this.color) / 255.0F;
	}

	public float getAlpha() {
		return class_5253.class_5254.method_27762(this.color) / 255.0F;
	}

	public static EntityEffectParticleEffect create(class_2396<EntityEffectParticleEffect> type, int color) {
		return new EntityEffectParticleEffect(type, color);
	}

	public static EntityEffectParticleEffect create(class_2396<EntityEffectParticleEffect> type, float r, float g, float b) {
		return create(type, fromFloats(1.0F, r, g, b));
	}

	public static int fromFloats(float a, float r, float g, float b) {
		return class_5253.class_5254.method_27764(channelFromFloat(a), channelFromFloat(r), channelFromFloat(g), channelFromFloat(b));
	}

	private static int channelFromFloat(float value) {
		return class_3532.method_15375(value * 255.0F);
	}
}
