/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.component;

import com.mojang.serialization.DynamicOps;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import dev.onyxstudios.cca.api.v3.item.ItemComponent;
import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class ElementalInfusionComponent
extends ItemComponent {
    private static final Logger LOGGER = SevenElements.sublogger();
    public static final ComponentKey<ElementalInfusionComponent> KEY = ComponentRegistry.getOrCreate((class_2960)SevenElements.identifier("elemental_infusion"), ElementalInfusionComponent.class);

    public ElementalInfusionComponent(class_1799 stack) {
        super(stack);
    }

    public static Optional<ElementalDamageSource> applyToDamageSource(class_1282 source, class_1297 target) {
        try {
            class_1297 class_12972;
            class_1309 livingTarget;
            block7: {
                block6: {
                    if (source.method_48790() || !(target instanceof class_1309)) break block6;
                    livingTarget = (class_1309)target;
                    class_12972 = source.method_5529();
                    if (class_12972 instanceof class_1309) break block7;
                }
                return Optional.empty();
            }
            class_1309 attacker = (class_1309)class_12972;
            ElementalInfusionComponent component = ElementalInfusionComponent.get(attacker.method_6047());
            if (component == null || !component.hasElementalInfusion()) {
                return Optional.empty();
            }
            return Optional.of(new ElementalDamageSource(source, component.getElementalInfusion(livingTarget), component.internalCooldown().build(attacker)));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static void applyInfusion(class_1799 stack, ElementalApplication.Builder applicationBuilder, InternalCooldownContext.Builder icdBuilder) {
        ElementalInfusionComponent component = ElementalInfusionComponent.get(stack);
        if (component == null) {
            return;
        }
        component.setElementalInfusion(applicationBuilder);
        component.setInternalCooldown(icdBuilder);
    }

    public static boolean removeInfusion(class_1799 stack) {
        if (!ElementalInfusionComponent.hasInfusion(stack)) {
            return false;
        }
        ElementalInfusionComponent component = ElementalInfusionComponent.get(stack);
        if (component == null) {
            return false;
        }
        component.remove("elemental_infusion");
        component.remove("internal_cooldown");
        return true;
    }

    public static boolean hasInfusion(class_1799 stack) {
        return Optional.of(ElementalInfusionComponent.get(stack)).map(ElementalInfusionComponent::hasElementalInfusion).orElse(false);
    }

    @Nullable
    public static ElementalInfusionComponent get(class_1799 stack) {
        return KEY.maybeGet((Object)stack).orElse(null);
    }

    @Nullable
    public ElementalApplication.Builder elementalInfusion() {
        return this.hasElementalInfusion() ? (ElementalApplication.Builder)ElementalApplication.Builder.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)this.getCompound("elemental_infusion")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseThrow() : null;
    }

    @Nullable
    public InternalCooldownContext.Builder internalCooldown() {
        return this.hasTag("internal_cooldown", 10) ? (InternalCooldownContext.Builder)InternalCooldownContext.Builder.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)this.getCompound("internal_cooldown")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseThrow() : null;
    }

    public boolean hasElementalInfusion() {
        return this.hasTag("elemental_infusion", 10);
    }

    @Nullable
    public ElementalApplication getElementalInfusion(class_1309 target) {
        return this.hasElementalInfusion() ? this.elementalInfusion().build(target) : null;
    }

    @Nullable
    public Element getElement() {
        return this.hasElementalInfusion() ? this.elementalInfusion().getElement() : null;
    }

    public double getGaugeUnits() {
        return this.hasElementalInfusion() ? this.getGaugeUnits() : 0.0;
    }

    public void setElementalInfusion(ElementalApplication.Builder builder) {
        this.putCompound("elemental_infusion", (class_2487)ElementalApplication.Builder.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)builder).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseThrow());
    }

    public void setInternalCooldown(InternalCooldownContext.Builder builder) {
        this.putCompound("internal_cooldown", (class_2487)InternalCooldownContext.Builder.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)builder).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseThrow());
    }

    public Optional<ElementalDamageSource> apply(class_1282 source, class_1297 target) {
        class_1309 attacker;
        class_1309 livingTarget;
        block3: {
            block2: {
                if (!(target instanceof class_1309)) break block2;
                livingTarget = (class_1309)target;
                class_1297 class_12972 = source.method_5529();
                if (!(class_12972 instanceof class_1309)) break block2;
                attacker = (class_1309)class_12972;
                if (this.hasElementalInfusion()) break block3;
            }
            return Optional.empty();
        }
        return Optional.of(new ElementalDamageSource(source, this.getElementalInfusion(livingTarget), this.internalCooldown().build(attacker)));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ElementalInfusionComponent)) {
            return false;
        }
        ElementalInfusionComponent component = (ElementalInfusionComponent)((Object)obj);
        return Objects.equals(this.elementalInfusion(), component.elementalInfusion()) && Objects.equals(this.internalCooldown(), component.internalCooldown());
    }
}

