package io.github.xrickastley.sevenelements.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import io.github.xrickastley.sevenelements.effect.SevenElementsStatusEffects;
import net.minecraft.class_1657;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_4970.class_4971;

// Prioritized since Frozen **MUST** disable block placements.
@Mixin(value = class_4971.class, priority = Integer.MIN_VALUE)
public class AbstractBlockStateMixin {
	@ModifyReturnValue(
		method = "getOutlineShape(Lnet/minecraft/world/BlockView;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/ShapeContext;)Lnet/minecraft/util/shape/VoxelShape;",
		at = @At("RETURN")
	)
	private class_265 frozenPreventsBlockPlace(class_265 original, @Local(argsOnly = true) class_3726 context) {
		return context instanceof final class_3727 esc
			&& esc.method_32480() instanceof final class_1657 player
			&& player.method_6059(SevenElementsStatusEffects.FROZEN)
			? class_259.method_1073()
			: original;
	}
}
