package io.github.xrickastley.sevenelements.mixin;

import java.util.Collection;
import java.util.Set;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import io.github.xrickastley.sevenelements.networking.SyncBossBarEntityS2CPayload;

import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1259;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

@Mixin(class_3213.class)
public abstract class ServerBossBarMixin extends class_1259 {
	@Shadow
	@Final
	private Set<class_3222> players;

	@Shadow
	public abstract Collection<class_3222> getPlayers();

	public ServerBossBarMixin(class_2561 displayName, class_1259.class_1260 color, class_1259.class_1261 style) {
		super(class_3532.method_15394(), displayName, color, style);

		throw new AssertionError();
	}

	@Unique
	@Override
	public void sevenelements$setEntity(class_1309 entity) {
		super.sevenelements$setEntity(entity);

		final SyncBossBarEntityS2CPayload packet = new SyncBossBarEntityS2CPayload(this, this.sevenelements$getEntity());

		this.getPlayers()
			.forEach(player -> ServerPlayNetworking.send(player, packet));
	}

	@Inject(
		method = "addPlayer",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/server/network/ServerPlayNetworkHandler;sendPacket(Lnet/minecraft/network/packet/Packet;)V"
		)
	)
	private void sendEntitySync(class_3222 player, CallbackInfo ci) {
		if (this.sevenelements$getEntity() == null) return;

		final SyncBossBarEntityS2CPayload packet = new SyncBossBarEntityS2CPayload(this, this.sevenelements$getEntity());

		ServerPlayNetworking.send(player, packet);
	}
}
