/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.xrickastley.sevenelements.command.CommandUtils;
import io.github.xrickastley.sevenelements.command.ElementArgumentType;
import io.github.xrickastley.sevenelements.command.InternalCooldownTagType;
import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.component.ElementalInfusionComponent;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementHolder;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.element.InternalCooldownTag;
import io.github.xrickastley.sevenelements.element.InternalCooldownType;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReaction;
import io.github.xrickastley.sevenelements.registry.SevenElementsRegistryKeys;
import io.github.xrickastley.sevenelements.util.Array;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;
import io.github.xrickastley.sevenelements.util.Functions;
import io.github.xrickastley.sevenelements.util.JavaScriptUtil;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import org.jetbrains.annotations.Nullable;

public class ElementCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"element").requires(cs -> cs.method_9259(2))).then(class_2170.method_9247((String)"apply").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"element", (ArgumentType)ElementArgumentType.element()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"gaugeUnits", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(ElementCommand::applyGaugeUnit)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"gaugeUnit").executes(ElementCommand::applyGaugeUnit)).then(class_2170.method_9244((String)"isAura", (ArgumentType)BoolArgumentType.bool()).executes(ElementCommand::applyGaugeUnit)))).then(class_2170.method_9247((String)"duration").then(class_2170.method_9244((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ElementCommand::applyDuration)))))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"element", (ArgumentType)ElementArgumentType.element()).executes(ElementCommand::removeElement))))).then(class_2170.method_9247((String)"reduce").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"element", (ArgumentType)ElementArgumentType.element()).then(class_2170.method_9244((String)"gaugeUnits", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(ElementCommand::reduceElement)))))).then(class_2170.method_9247((String)"query").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).executes(ElementCommand::queryElements)).then(class_2170.method_9244((String)"element", (ArgumentType)ElementArgumentType.element()).executes(ElementCommand::queryElement))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"infusion").then(class_2170.method_9247((String)"apply").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"element", (ArgumentType)ElementArgumentType.element()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"gaugeUnits", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(ElementCommand::infuseGaugeUnit)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"gaugeUnit").executes(ElementCommand::infuseGaugeUnit)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"tag", (ArgumentType)InternalCooldownTagType.tag()).executes(ElementCommand::infuseGaugeUnit)).then(class_2170.method_9244((String)"type", (ArgumentType)class_7733.method_45603((class_7157)registryAccess, SevenElementsRegistryKeys.INTERNAL_COOLDOWN_TYPE)).executes(ElementCommand::infuseGaugeUnit))))).then(class_2170.method_9247((String)"duration").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ElementCommand::infuseDuration)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"tag", (ArgumentType)InternalCooldownTagType.tag()).executes(ElementCommand::infuseDuration)).then(class_2170.method_9244((String)"type", (ArgumentType)class_7733.method_45603((class_7157)registryAccess, SevenElementsRegistryKeys.INTERNAL_COOLDOWN_TYPE)).executes(ElementCommand::infuseDuration)))))))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(ElementCommand::infuseRemove)))));
    }

    private static int applyGaugeUnit(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 entity = class_2186.method_9313(context, (String)"target");
        Element element = ElementArgumentType.getElement(context, "element");
        double gaugeUnits = DoubleArgumentType.getDouble(context, (String)"gaugeUnits");
        boolean aura = CommandUtils.getOrDefault(context, "isAura", Boolean.class, true);
        if (!(entity instanceof class_1309)) {
            return CommandUtils.sendError(context, (class_2561)class_2561.method_43469((String)"commands.element.failed.entity", (Object[])new Object[]{entity}));
        }
        class_1309 target = (class_1309)entity;
        ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)target);
        ElementalApplication application = ElementalApplications.gaugeUnits(target, element, gaugeUnits, aura);
        List<ElementalReaction> reactions = component.addElementalApplication(application, InternalCooldownContext.ofNone());
        if (reactions.isEmpty()) {
            return CommandUtils.sendFeedback(context, (class_2561)class_2561.method_43469((String)"commands.element.apply", (Object[])new Object[]{application.getText(), entity.method_5476()}), true);
        }
        return CommandUtils.sendFeedback(context, (class_2561)class_2561.method_43469((String)"commands.element.apply.reactions", (Object[])new Object[]{application.getText(), entity.method_5476(), class_2564.method_10884(reactions, Functions.compose(ElementalReaction::getId, class_2960::toString, class_2561::method_43470))}), true);
    }

    private static int applyDuration(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 entity = class_2186.method_9313(context, (String)"target");
        Element element = ElementArgumentType.getElement(context, "element");
        double gaugeUnits = DoubleArgumentType.getDouble(context, (String)"gaugeUnits");
        int duration = IntegerArgumentType.getInteger(context, (String)"duration");
        if (!(entity instanceof class_1309)) {
            return CommandUtils.sendError(context, (class_2561)class_2561.method_43469((String)"commands.element.failed.entity", (Object[])new Object[]{entity}));
        }
        class_1309 target = (class_1309)entity;
        ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)target);
        ElementalApplication application = ElementalApplications.duration(target, element, gaugeUnits, duration);
        List<ElementalReaction> reactions = component.addElementalApplication(application, InternalCooldownContext.ofNone());
        if (reactions.isEmpty()) {
            return CommandUtils.sendFeedback(context, (class_2561)class_2561.method_43469((String)"commands.element.apply", (Object[])new Object[]{element.getText(), entity.method_5476()}), true);
        }
        return CommandUtils.sendFeedback(context, (class_2561)class_2561.method_43469((String)"commands.element.apply.reactions", (Object[])new Object[]{element.getText(), entity.method_5476(), class_2564.method_10884(reactions, Functions.compose(ElementalReaction::getId, class_2960::toString, class_2561::method_43470))}), true);
    }

    private static int removeElement(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 entity = class_2186.method_9313(context, (String)"target");
        Element element = ElementArgumentType.getElement(context, "element");
        if (!(entity instanceof class_1309)) {
            return CommandUtils.sendError(context, (class_2561)class_2561.method_43469((String)"commands.element.failed.entity", (Object[])new Object[]{entity}));
        }
        class_1309 target = (class_1309)entity;
        ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)target);
        ElementHolder holder = component.getElementHolder(element);
        if (!holder.hasElementalApplication()) {
            return CommandUtils.sendError(context, (class_2561)class_2561.method_43469((String)"commands.element.failed.none", (Object[])new Object[]{entity.method_5476(), element.getText()}));
        }
        holder.setElementalApplication(null);
        ElementComponent.sync(entity);
        return CommandUtils.sendFeedback(context, (class_2561)class_2561.method_43469((String)"commands.element.remove", (Object[])new Object[]{element.getText(), entity}), true);
    }

    private static int reduceElement(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 entity = class_2186.method_9313(context, (String)"target");
        Element element = ElementArgumentType.getElement(context, "element");
        double gaugeUnits = DoubleArgumentType.getDouble(context, (String)"gaugeUnits");
        if (!(entity instanceof class_1309)) {
            return CommandUtils.sendError(context, (class_2561)class_2561.method_43469((String)"commands.element.failed.entity", (Object[])new Object[]{entity}));
        }
        class_1309 target = (class_1309)entity;
        ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)target);
        ElementHolder holder = component.getElementHolder(element);
        if (!holder.hasElementalApplication()) {
            return CommandUtils.sendError(context, (class_2561)class_2561.method_43469((String)"commands.element.failed.none", (Object[])new Object[]{entity.method_5476(), element.getText()}));
        }
        double reducedGauge = holder.getElementalApplication().reduceGauge(gaugeUnits);
        ElementComponent.sync(entity);
        return CommandUtils.sendFeedback(context, (class_2561)class_2561.method_43469((String)"commands.element.reduce", (Object[])new Object[]{element.getText(), reducedGauge}), true);
    }

    private static int queryElements(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 entity = class_2186.method_9313(context, (String)"target");
        if (!(entity instanceof class_1309)) {
            return CommandUtils.sendError(context, (class_2561)class_2561.method_43469((String)"commands.element.failed.entity", (Object[])new Object[]{entity}));
        }
        class_1309 target = (class_1309)entity;
        ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)target);
        Array<ElementalApplication> appliedElements = component.getAppliedElements();
        if (appliedElements.isEmpty()) {
            return CommandUtils.sendError(context, (class_2561)class_2561.method_43469((String)"commands.element.query.multiple.none", (Object[])new Object[]{entity}));
        }
        return CommandUtils.sendFeedback(context, (class_2561)class_2561.method_43469((String)"commands.element.query.multiple.success", (Object[])new Object[]{entity.method_5476(), class_2564.method_10884(appliedElements, ElementalApplications::getTimerText)}), true);
    }

    private static int queryElement(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 entity = class_2186.method_9313(context, (String)"target");
        Element element = ElementArgumentType.getElement(context, "element");
        if (!(entity instanceof class_1309)) {
            return CommandUtils.sendError(context, (class_2561)class_2561.method_43469((String)"commands.element.failed.entity", (Object[])new Object[]{entity}));
        }
        class_1309 target = (class_1309)entity;
        ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)target);
        @Nullable ElementalApplication application = component.getElementHolder(element).getElementalApplication();
        if (application == null) {
            return CommandUtils.sendError(context, (class_2561)class_2561.method_43469((String)"commands.element.query.single.none", (Object[])new Object[]{entity.method_5476(), element.getText()}));
        }
        return CommandUtils.sendFeedback(context, (class_2561)class_2561.method_43469((String)"commands.element.query.single.success", (Object[])new Object[]{entity.method_5476(), ElementalApplications.getTimerText(application)}), true);
    }

    private static int infuseGaugeUnit(CommandContext<class_2168> context) throws CommandSyntaxException {
        Element element = ElementArgumentType.getElement(context, "element");
        double gaugeUnits = DoubleArgumentType.getDouble(context, (String)"gaugeUnits");
        InternalCooldownTag tag = InternalCooldownTagType.getTagOrDefault(context, "tag", InternalCooldownTag.NONE);
        // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable class_6880.class_6883 typeRef = (class_6880.class_6883)ClassInstanceUtil.cast(CommandUtils.getOrDefault(context, "type", class_6880.class_6883.class, null));
        InternalCooldownType type = JavaScriptUtil.nullishCoalesing(ClassInstanceUtil.mapOrNull(typeRef, class_6880.class_6883::comp_349), InternalCooldownType.DEFAULT);
        class_1297 entity = class_2186.method_9313(context, (String)"entity");
        if (!(entity instanceof class_1309)) {
            return CommandUtils.sendError(context, (class_2561)class_2561.method_43469((String)"commands.enchant.failed.entity", (Object[])new Object[]{entity.method_5476()}));
        }
        class_1309 livingEntity = (class_1309)entity;
        class_1799 stack = livingEntity.method_6047();
        if (stack.method_7960()) {
            return CommandUtils.sendError(context, (class_2561)class_2561.method_43469((String)"commands.enchant.failed.itemless", (Object[])new Object[]{entity.method_5476()}));
        }
        ElementalApplication.Builder infusionBuilder = ElementalApplications.builder().setType(ElementalApplication.Type.GAUGE_UNIT).setElement(element).setGaugeUnits(gaugeUnits).setAsAura(false);
        InternalCooldownContext.Builder icdBuilder = InternalCooldownContext.builder().setTag(tag).setType(type);
        ElementalInfusionComponent.applyInfusion(stack, infusionBuilder, icdBuilder);
        class_2561 elementText = ElementalApplication.Builder.getText(infusionBuilder);
        class_5250 icdText = class_2561.method_43473().method_10852(tag.getText(class_124.field_1068)).method_27693("/").method_10852((class_2561)type.getText());
        return CommandUtils.sendFeedback(context, (class_2561)class_2561.method_43469((String)"commands.element.infuse.apply.success", (Object[])new Object[]{elementText, icdText, entity.method_5476()}), true);
    }

    private static int infuseDuration(CommandContext<class_2168> context) throws CommandSyntaxException {
        Element element = ElementArgumentType.getElement(context, "element");
        double gaugeUnits = DoubleArgumentType.getDouble(context, (String)"gaugeUnits");
        int duration = IntegerArgumentType.getInteger(context, (String)"duration");
        InternalCooldownTag tag = InternalCooldownTagType.getTagOrDefault(context, "tag", InternalCooldownTag.NONE);
        // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable class_6880.class_6883 typeRef = (class_6880.class_6883)ClassInstanceUtil.cast(CommandUtils.getOrDefault(context, "type", class_6880.class_6883.class, null));
        InternalCooldownType type = JavaScriptUtil.nullishCoalesing(ClassInstanceUtil.mapOrNull(typeRef, class_6880.class_6883::comp_349), InternalCooldownType.DEFAULT);
        class_1297 entity = class_2186.method_9313(context, (String)"entity");
        if (!(entity instanceof class_1309)) {
            return CommandUtils.sendError(context, (class_2561)class_2561.method_43469((String)"commands.enchant.failed.entity", (Object[])new Object[]{entity.method_5476()}));
        }
        class_1309 livingEntity = (class_1309)entity;
        class_1799 stack = livingEntity.method_6047();
        if (stack.method_7960()) {
            return CommandUtils.sendError(context, (class_2561)class_2561.method_43469((String)"commands.enchant.failed.itemless", (Object[])new Object[]{entity.method_5476()}));
        }
        ElementalApplication.Builder infusionBuilder = ElementalApplications.builder().setType(ElementalApplication.Type.DURATION).setElement(element).setGaugeUnits(gaugeUnits).setDuration(duration);
        InternalCooldownContext.Builder icdBuilder = InternalCooldownContext.builder().setTag(tag).setType(type);
        ElementalInfusionComponent.applyInfusion(stack, infusionBuilder, icdBuilder);
        class_2561 elementText = ElementalApplication.Builder.getText(infusionBuilder);
        class_5250 icdText = class_2561.method_43473().method_10852(tag.getText()).method_27693("/").method_10852((class_2561)type.getText());
        return CommandUtils.sendFeedback(context, (class_2561)class_2561.method_43469((String)"commands.element.infuse.apply.success", (Object[])new Object[]{elementText, icdText, entity.method_5476()}), true);
    }

    private static int infuseRemove(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 entity = class_2186.method_9313(context, (String)"entity");
        if (!(entity instanceof class_1309)) {
            return CommandUtils.sendError(context, (class_2561)class_2561.method_43469((String)"commands.enchant.failed.entity", (Object[])new Object[]{entity.method_5476()}));
        }
        class_1309 livingEntity = (class_1309)entity;
        class_1799 stack = livingEntity.method_6047();
        if (stack.method_7960()) {
            return CommandUtils.sendError(context, (class_2561)class_2561.method_43469((String)"commands.enchant.failed.itemless", (Object[])new Object[]{entity.method_5476()}));
        }
        return ElementalInfusionComponent.removeInfusion(stack) ? CommandUtils.sendFeedback(context, (class_2561)class_2561.method_43469((String)"commands.element.infuse.remove.success", (Object[])new Object[]{entity.method_5476()}), true) : CommandUtils.sendError(context, (class_2561)class_2561.method_43469((String)"commands.element.infuse.remove.none", (Object[])new Object[]{entity.method_5476()}));
    }
}

