/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.effect;

import io.github.xrickastley.sevenelements.effect.CryoStatusEffect;
import io.github.xrickastley.sevenelements.effect.FrozenStatusEffect;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.events.ElementEvents;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;
import io.github.xrickastley.sevenelements.util.Functions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_2378;
import net.minecraft.class_3222;
import net.minecraft.class_4081;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public abstract sealed class ElementalStatusEffect
extends class_1291
permits CryoStatusEffect, FrozenStatusEffect {
    private static final Map<Element, ElementalStatusEffect> ELEMENT_EFFECTS = new HashMap<Element, ElementalStatusEffect>();
    private final Element element;

    ElementalStatusEffect(class_4081 category, int color, Element element) {
        super(category, color);
        if (ELEMENT_EFFECTS.containsKey((Object)element)) {
            throw new IllegalArgumentException("An ElementalStatusEffect for the provided element: " + String.valueOf((Object)element) + " already exists: " + ((Object)((Object)ELEMENT_EFFECTS.get((Object)element))).getClass().getName());
        }
        this.element = element;
        ELEMENT_EFFECTS.put(element, this);
    }

    @Nullable
    public static ElementalStatusEffect getEffectForElement(Element element) {
        return ELEMENT_EFFECTS.get((Object)element);
    }

    @Nullable
    public static class_6880<class_1291> getEntryForElement(Element element) {
        ElementalStatusEffect effect = ELEMENT_EFFECTS.get((Object)element);
        if (effect == null) {
            return null;
        }
        return class_7923.field_41174.method_47983((Object)effect);
    }

    public static List<class_6880<class_1291>> getElementEffects() {
        return ELEMENT_EFFECTS.values().stream().map(arg_0 -> ((class_2378)class_7923.field_41174).method_47983(arg_0)).toList();
    }

    public static Optional<ElementalStatusEffect> asElementEffect(class_6880<class_1291> effect) {
        return Optional.ofNullable(ClassInstanceUtil.castOrNull(effect.comp_349(), ElementalStatusEffect.class));
    }

    public static void applyPossibleStatusEffect(ElementalApplication application) {
        ElementalStatusEffect effect = ElementalStatusEffect.getEffectForElement(application.getElement());
        if (effect == null) {
            return;
        }
        effect.applyStatusEffect(application);
    }

    public static boolean isElementalEffect(class_6880<class_1291> effect) {
        return effect.comp_349() instanceof ElementalStatusEffect;
    }

    public Element getElement() {
        return this.element;
    }

    public void applyStatusEffect(ElementalApplication application) {
        if (application.getElement() != this.element) {
            return;
        }
        application.getEntity().method_6092(new class_1293(class_7923.field_41174.method_47983((Object)this), application.getRemainingTicks(), 0, true, false, true));
    }

    static {
        ElementEvents.APPLIED.register((Object)Handler.INSTANCE);
        ElementEvents.REAPPLIED.register((Object)Handler.INSTANCE);
        ElementEvents.REFRESHED.register((Object)Handler.INSTANCE);
        ElementEvents.REMOVED.register((Object)Handler.INSTANCE);
    }

    private static class Handler
    implements ElementEvents.ElementApplied,
    ElementEvents.ElementReapplied,
    ElementEvents.ElementRefreshed,
    ElementEvents.ElementRemoved {
        private static final Handler INSTANCE = new Handler();

        private Handler() {
        }

        @Override
        public void onElementApplied(Element element, ElementalApplication application) {
            class_1309 class_13092 = application.getEntity();
            if (class_13092 instanceof class_3222) {
                class_3222 player = (class_3222)class_13092;
                if (player.field_13987 == null) {
                    return;
                }
            }
            ClassInstanceUtil.ifPresentMapped(element, ElementalStatusEffect::getEffectForElement, Functions.withArgument(ElementalStatusEffect::applyStatusEffect, application));
        }

        @Override
        public void onElementReapplied(Element element, ElementalApplication result) {
            class_1309 class_13092 = result.getEntity();
            if (class_13092 instanceof class_3222) {
                class_3222 player = (class_3222)class_13092;
                if (player.field_13987 == null) {
                    return;
                }
            }
            ClassInstanceUtil.ifPresentMapped(element, ElementalStatusEffect::getEffectForElement, Functions.withArgument(ElementalStatusEffect::applyStatusEffect, result));
        }

        @Override
        public void onElementRefreshed(Element element, ElementalApplication current, ElementalApplication previous) {
            class_1309 class_13092 = current.getEntity();
            if (class_13092 instanceof class_3222) {
                class_3222 player = (class_3222)class_13092;
                if (player.field_13987 == null) {
                    return;
                }
            }
            ClassInstanceUtil.ifPresentMapped(element, ElementalStatusEffect::getEffectForElement, Functions.withArgument(ElementalStatusEffect::applyStatusEffect, current));
        }

        @Override
        public void onElementRemoved(Element element, ElementalApplication application) {
            class_1309 class_13092 = application.getEntity();
            if (class_13092 instanceof class_3222) {
                class_3222 player = (class_3222)class_13092;
                if (player.field_13987 == null) {
                    return;
                }
            }
            ClassInstanceUtil.ifPresentMapped(element, ElementalStatusEffect::getEffectForElement, Functions.composeConsumer(arg_0 -> ((class_2378)class_7923.field_41174).method_47983(arg_0), arg_0 -> ((class_1309)application.getEntity()).method_6016(arg_0)));
        }
    }
}

