/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_8909;
import org.slf4j.helpers.MessageFormatter;

public class NbtHelper {
    public static <T> T get(class_2487 nbt, String key, Codec<T> codec) {
        return nbt.method_67491(key, codec).orElseThrow(() -> new class_8909("Expected value for required field: " + key));
    }

    public static <T> List<T> getList(class_2487 nbt, String key, Codec<T> entryCodec) {
        ArrayList result = new ArrayList();
        class_2499 list = nbt.method_68569(key);
        for (int i = 0; i < list.size(); ++i) {
            class_2520 element = (class_2520)list.get(i);
            entryCodec.parse((DynamicOps)class_2509.field_11560, (Object)element).resultOrPartial(NbtHelper.createErrorConsumer("Failed to read entry at array[{}] ({})", i, element)).ifPresent(result::add);
        }
        return result;
    }

    public static <T> void putList(class_2487 nbt, String key, Codec<T> entryCodec, List<T> list) {
        class_2499 result = new class_2499();
        for (int i = 0; i < list.size(); ++i) {
            T element = list.get(i);
            entryCodec.encodeStart((DynamicOps)class_2509.field_11560, element).resultOrPartial(NbtHelper.createErrorConsumer("Failed to write entry at array[{}] ({})", i, element)).ifPresent(arg_0 -> result.add(arg_0));
        }
        nbt.method_10566(key, (class_2520)result);
    }

    private static Consumer<String> createErrorConsumer(String message, Object ... arguments) {
        return err -> {
            throw new class_8909(String.valueOf(MessageFormatter.arrayFormat((String)message, (Object[])arguments)) + ": " + err);
        };
    }
}

