/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.element;

import io.github.xrickastley.sevenelements.component.ElementComponentImpl;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.element.InternalCooldown;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.element.InternalCooldownHolder;
import io.github.xrickastley.sevenelements.events.ElementEvents;
import io.github.xrickastley.sevenelements.factory.SevenElementsGameRules;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public final class ElementHolder {
    private final class_1309 owner;
    final Map<UUID, InternalCooldownHolder> internalCooldowns = new ConcurrentHashMap<UUID, InternalCooldownHolder>();
    private final Element element;
    @Nullable
    private ElementalApplication application;

    public static ElementHolder of(class_1309 owner, Element element) {
        return new ElementHolder(owner, element);
    }

    public static ElementHolder ofApplication(class_1309 owner, Element element, ElementalApplication application) {
        if (application.getElement() != element) {
            throw new IllegalArgumentException("The provided ElementalApplication's element must match that of the provided element argument!");
        }
        return new ElementHolder(owner, element, application);
    }

    private ElementHolder(class_1309 owner, Element element) {
        this(owner, element, null);
    }

    private ElementHolder(class_1309 owner, Element element, ElementalApplication application) {
        this.owner = owner;
        this.element = element;
        this.application = this.shouldDoElements() ? application : null;
    }

    public boolean hasElementalApplication() {
        return this.application != null && !this.application.isEmpty();
    }

    public Element getElement() {
        return this.element;
    }

    @Nullable
    public ElementalApplication getElementalApplication() {
        return this.application;
    }

    public ElementalApplication getOrCreateElementalApplication(double gaugeUnits, boolean aura) {
        if (!this.shouldDoElements()) {
            throw new IllegalStateException("The Game Rule \"doElements\" is false! Check if you can apply elements through ElementHolder#shouldDoElements before calling this method!");
        }
        if (this.application == null) {
            this.setElementalApplication(ElementalApplications.gaugeUnits(this.owner, this.element, gaugeUnits, aura));
        }
        return this.application;
    }

    public ElementalApplication getOrCreateElementalApplication(double duration, double gaugeUnits) {
        if (!this.shouldDoElements()) {
            throw new IllegalStateException("The Game Rule \"doElements\" is false! Check if you can apply elements through ElementHolder#shouldDoElements before calling this method!");
        }
        if (this.application == null) {
            this.setElementalApplication(ElementalApplications.duration(this.owner, this.element, gaugeUnits, duration));
        }
        return this.application;
    }

    public void setElementalApplication(@Nullable ElementalApplication application) {
        if (!this.shouldDoElements() || !ElementComponentImpl.canApplyElement(this.owner.getClass())) {
            return;
        }
        @Nullable ElementalApplication prev = this.application;
        this.application = application;
        if (prev != null && application == null) {
            ((ElementEvents.ElementRemoved)ElementEvents.REMOVED.invoker()).onElementRemoved(this.element, prev);
        } else if (prev == null && this.application != null) {
            ((ElementEvents.ElementApplied)ElementEvents.APPLIED.invoker()).onElementApplied(this.element, application);
        } else if (prev != null) {
            ((ElementEvents.ElementRefreshed)ElementEvents.REFRESHED.invoker()).onElementRefreshed(this.element, application, prev);
        }
    }

    public boolean shouldDoElements() {
        class_3218 world;
        class_1937 class_19372 = this.owner.method_37908();
        return !(class_19372 instanceof class_3218) || (world = (class_3218)class_19372).method_64395().method_8355(SevenElementsGameRules.DO_ELEMENTS);
    }

    public boolean canApplyElement(Element element, InternalCooldownContext icdContext) {
        return this.canApplyElement(element, icdContext, false);
    }

    public boolean canApplyElement(Element element, InternalCooldownContext icdContext, boolean handleICD) {
        if (element.bypassesInternalCooldown()) {
            return true;
        }
        InternalCooldown icdData = icdContext.getInternalCooldown(this);
        return handleICD ? icdData.handleInternalCooldown() : icdData.isInInternalCooldown();
    }

    public class_1309 getOwner() {
        return this.owner;
    }
}

