/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.element.reaction;

import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.element.reaction.CryoCrystallizeElementalReaction;
import io.github.xrickastley.sevenelements.element.reaction.ElectroCrystallizeElementalReaction;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReaction;
import io.github.xrickastley.sevenelements.element.reaction.FrozenCrystallizeElementalReaction;
import io.github.xrickastley.sevenelements.element.reaction.HydroCrystallizeElementalReaction;
import io.github.xrickastley.sevenelements.element.reaction.PyroCrystallizeElementalReaction;
import io.github.xrickastley.sevenelements.entity.CrystallizeShardEntity;
import io.github.xrickastley.sevenelements.entity.SevenElementsEntityTypes;
import io.github.xrickastley.sevenelements.util.Functions;
import io.github.xrickastley.sevenelements.util.MathHelper2;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public abstract sealed class AbstractCrystallizeElementalReaction
extends ElementalReaction
permits PyroCrystallizeElementalReaction, HydroCrystallizeElementalReaction, ElectroCrystallizeElementalReaction, CryoCrystallizeElementalReaction, FrozenCrystallizeElementalReaction {
    private static final Set<class_2248> AIR_BLOCKS = Set.of(class_2246.field_10124, class_2246.field_10543, class_2246.field_10243);

    AbstractCrystallizeElementalReaction(ElementalReaction.Settings settings) {
        super(settings);
    }

    @Override
    protected void onReaction(class_1309 entity, ElementalApplication auraElement, ElementalApplication triggeringElement, double reducedGauge, @Nullable class_1309 origin) {
        class_1937 world = entity.method_37908();
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        class_243 spawnPos = this.clampToGround(entity.method_37908(), this.toAbsolutePos(entity, new class_243(0.0, 0.0, 1.0)));
        CrystallizeShardEntity crystallizeShard = new CrystallizeShardEntity(SevenElementsEntityTypes.CRYSTALLIZE_SHARD, (class_1937)serverWorld, this.getAuraElement(), origin);
        crystallizeShard.method_33574(spawnPos);
        serverWorld.method_30736((class_1297)crystallizeShard);
    }

    private class_243 toAbsolutePos(class_1309 entity, class_243 lookingPos) {
        class_241 vec2f = entity.method_5802();
        class_243 vec3d = entity.method_19538();
        float f = class_3532.method_15362((float)((vec2f.field_1342 + 90.0f) * ((float)Math.PI / 180)));
        float g = class_3532.method_15374((float)((vec2f.field_1342 + 90.0f) * ((float)Math.PI / 180)));
        float h = class_3532.method_15362((float)(-vec2f.field_1343 * ((float)Math.PI / 180)));
        float i = class_3532.method_15374((float)(-vec2f.field_1343 * ((float)Math.PI / 180)));
        float j = class_3532.method_15362((float)((-vec2f.field_1343 + 90.0f) * ((float)Math.PI / 180)));
        float k = class_3532.method_15374((float)((-vec2f.field_1343 + 90.0f) * ((float)Math.PI / 180)));
        class_243 vec3d2 = new class_243((double)(f * h), (double)i, (double)(g * h));
        class_243 vec3d3 = new class_243((double)(f * j), (double)k, (double)(g * j));
        class_243 vec3d4 = vec3d2.method_1036(vec3d3).method_1021(-1.0);
        double d = vec3d2.field_1352 * lookingPos.field_1350 + vec3d3.field_1352 * lookingPos.field_1351 + vec3d4.field_1352 * lookingPos.field_1352;
        double e = vec3d2.field_1351 * lookingPos.field_1350 + vec3d3.field_1351 * lookingPos.field_1351 + vec3d4.field_1351 * lookingPos.field_1352;
        double l = vec3d2.field_1350 * lookingPos.field_1350 + vec3d3.field_1350 * lookingPos.field_1351 + vec3d4.field_1350 * lookingPos.field_1352;
        return new class_243(vec3d.field_1352 + d, vec3d.field_1351 + e, vec3d.field_1350 + l);
    }

    private class_243 clampToGround(class_1937 world, class_243 pos) {
        class_2338 originPos = MathHelper2.asBlockPos(pos);
        class_2680 blockState = world.method_8320(originPos);
        Optional<class_2338> blockPos = AIR_BLOCKS.contains(blockState.method_26204()) ? this.scan(world, originPos, new class_2382(0, -1, 0), Functions.composePredicate(class_4970.class_4971::method_26204, AIR_BLOCKS::contains), bp -> bp.method_10264() >= world.method_31607()).map(bp -> bp.method_10069(0, 1, 0)) : this.scan(world, originPos, new class_2382(0, 1, 0), Functions.composePredicate(class_4970.class_4971::method_26204, Predicate.not(AIR_BLOCKS::contains)), bp -> bp.method_10264() <= world.method_31600());
        class_2338 finalBlockPos = blockPos.orElse(originPos);
        return new class_243(pos.field_1352, (double)finalBlockPos.method_10264(), pos.field_1350);
    }

    private Optional<class_2338> scan(class_1937 world, class_2338 originPos, class_2382 shift, Predicate<class_2680> blockPredicate, Predicate<class_2338> posPredicate) {
        class_2338 blockPos = originPos;
        class_2680 blockState = world.method_8320(blockPos);
        while (posPredicate.test(blockPos)) {
            if (blockPredicate.test(blockState)) {
                blockPos = blockPos.method_10081(shift);
                blockState = world.method_8320(blockPos);
                continue;
            }
            int diff = originPos.method_10264() - blockPos.method_10264();
            return Optional.of(originPos.method_10069(0, -diff, 0));
        }
        return Optional.empty();
    }
}

