/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.factory;

import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1329;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5132;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class SevenElementsAttributes {
    private static final List<class_6880<class_1320>> ADDED_ATTRIBUTES = new ArrayList<class_6880<class_1320>>();
    private static final Map<Element, ConcurrentHashMap<ModifierType, class_6880<class_1320>>> LINKS = new ConcurrentHashMap<Element, ConcurrentHashMap<ModifierType, class_6880<class_1320>>>();
    private static boolean registered = false;
    public static final class_6880<class_1320> PHYSICAL_DMG_BONUS = SevenElementsAttributes.register("physical_dmg_bonus", SevenElementsAttributes.createAttribute("Physical DMG Bonus%", 0.0, 0.0, 400.0));
    public static final class_6880<class_1320> PYRO_DMG_BONUS = SevenElementsAttributes.register("pyro_dmg_bonus", SevenElementsAttributes.createAttribute("Pyro DMG Bonus%", 0.0, 0.0, 400.0));
    public static final class_6880<class_1320> HYDRO_DMG_BONUS = SevenElementsAttributes.register("hydro_dmg_bonus", SevenElementsAttributes.createAttribute("Hydro DMG Bonus%", 0.0, 0.0, 400.0));
    public static final class_6880<class_1320> ANEMO_DMG_BONUS = SevenElementsAttributes.register("anemo_dmg_bonus", SevenElementsAttributes.createAttribute("Anemo DMG Bonus%", 0.0, 0.0, 400.0));
    public static final class_6880<class_1320> ELECTRO_DMG_BONUS = SevenElementsAttributes.register("electro_dmg_bonus", SevenElementsAttributes.createAttribute("Electro DMG Bonus%", 0.0, 0.0, 400.0));
    public static final class_6880<class_1320> DENDRO_DMG_BONUS = SevenElementsAttributes.register("dendro_dmg_bonus", SevenElementsAttributes.createAttribute("Dendro DMG Bonus%", 0.0, 0.0, 400.0));
    public static final class_6880<class_1320> CRYO_DMG_BONUS = SevenElementsAttributes.register("cryo_dmg_bonus", SevenElementsAttributes.createAttribute("Cryo DMG Bonus%", 0.0, 0.0, 400.0));
    public static final class_6880<class_1320> GEO_DMG_BONUS = SevenElementsAttributes.register("geo_dmg_bonus", SevenElementsAttributes.createAttribute("Geo DMG Bonus%", 0.0, 0.0, 400.0));
    public static final class_6880<class_1320> PHYSICAL_RES = SevenElementsAttributes.register("physical_res", SevenElementsAttributes.createAttribute("Physical RES%", 0.0, -200.0, 100.0));
    public static final class_6880<class_1320> PYRO_RES = SevenElementsAttributes.register("pyro_res", SevenElementsAttributes.createAttribute("Pyro RES%", 0.0, -200.0, 100.0));
    public static final class_6880<class_1320> HYDRO_RES = SevenElementsAttributes.register("hydro_res", SevenElementsAttributes.createAttribute("Hydro RES%", 0.0, -200.0, 100.0));
    public static final class_6880<class_1320> ANEMO_RES = SevenElementsAttributes.register("anemo_res", SevenElementsAttributes.createAttribute("Anemo RES%", 0.0, -200.0, 100.0));
    public static final class_6880<class_1320> ELECTRO_RES = SevenElementsAttributes.register("electro_res", SevenElementsAttributes.createAttribute("Electro RES%", 0.0, -200.0, 100.0));
    public static final class_6880<class_1320> DENDRO_RES = SevenElementsAttributes.register("dendro_res", SevenElementsAttributes.createAttribute("Dendro RES%", 0.0, -200.0, 100.0));
    public static final class_6880<class_1320> CRYO_RES = SevenElementsAttributes.register("cryo_res", SevenElementsAttributes.createAttribute("Cryo RES%", 0.0, -200.0, 100.0));
    public static final class_6880<class_1320> GEO_RES = SevenElementsAttributes.register("geo_res", SevenElementsAttributes.createAttribute("Geo RES%", 0.0, -200.0, 100.0));

    public static void register() {
        if (registered) {
            return;
        }
        SevenElementsAttributes.link(PHYSICAL_DMG_BONUS, Element.PHYSICAL, ModifierType.DMG_BONUS);
        SevenElementsAttributes.link(PYRO_DMG_BONUS, Element.PYRO, ModifierType.DMG_BONUS);
        SevenElementsAttributes.link(HYDRO_DMG_BONUS, Element.HYDRO, ModifierType.DMG_BONUS);
        SevenElementsAttributes.link(ANEMO_DMG_BONUS, Element.ANEMO, ModifierType.DMG_BONUS);
        SevenElementsAttributes.link(ELECTRO_DMG_BONUS, Element.ELECTRO, ModifierType.DMG_BONUS);
        SevenElementsAttributes.link(DENDRO_DMG_BONUS, Element.DENDRO, ModifierType.DMG_BONUS);
        SevenElementsAttributes.link(CRYO_DMG_BONUS, Element.CRYO, ModifierType.DMG_BONUS);
        SevenElementsAttributes.link(GEO_DMG_BONUS, Element.GEO, ModifierType.DMG_BONUS);
        SevenElementsAttributes.link(PHYSICAL_RES, Element.PHYSICAL, ModifierType.RES);
        SevenElementsAttributes.link(PYRO_RES, Element.PYRO, ModifierType.RES);
        SevenElementsAttributes.link(HYDRO_RES, Element.HYDRO, ModifierType.RES);
        SevenElementsAttributes.link(ANEMO_RES, Element.ANEMO, ModifierType.RES);
        SevenElementsAttributes.link(ELECTRO_RES, Element.ELECTRO, ModifierType.RES);
        SevenElementsAttributes.link(DENDRO_RES, Element.DENDRO, ModifierType.RES);
        SevenElementsAttributes.link(CRYO_RES, Element.CRYO, ModifierType.RES);
        SevenElementsAttributes.link(GEO_RES, Element.GEO, ModifierType.RES);
        registered = true;
    }

    public static float modifyDamage(class_1309 target, ElementalDamageSource source, float amount) {
        class_1297 class_12972 = source.method_5529();
        if (!(class_12972 instanceof class_1309)) {
            return amount;
        }
        class_1309 attacker = (class_1309)class_12972;
        Element element = source.getElementalApplication().getElement();
        ConcurrentHashMap modifierMap = LINKS.getOrDefault((Object)element, new ConcurrentHashMap());
        class_6880 dmgBonusAttribute = (class_6880)modifierMap.get((Object)ModifierType.DMG_BONUS);
        class_6880 resAttribute = (class_6880)modifierMap.get((Object)ModifierType.RES);
        float dmgBonusMultiplier = 1.0f + (target.method_6127().method_45331(dmgBonusAttribute) && source.applyDMGBonus() ? (float)(attacker.method_6127().method_26852(dmgBonusAttribute) / 100.0) : 0.0f);
        float resMultiplier = target.method_6127().method_45331(resAttribute) && source.applyRES() ? (float)SevenElementsAttributes.getRESMultiplier(target, (class_6880<class_1320>)resAttribute) : 1.0f;
        return amount * dmgBonusMultiplier * resMultiplier;
    }

    public static class_5132.class_5133 apply(class_5132.class_5133 builder) {
        SevenElementsAttributes.register();
        ADDED_ATTRIBUTES.forEach(arg_0 -> ((class_5132.class_5133)builder).method_26867(arg_0));
        return builder;
    }

    private static double getRESMultiplier(class_1309 target, class_6880<class_1320> resAttribute) {
        double elementalRes = target.method_6127().method_26852(resAttribute) / 100.0;
        return elementalRes < 0.0 ? 1.0 - elementalRes / 2.0 : (0.0 <= elementalRes && elementalRes < 0.75 ? 1.0 - elementalRes : 1.0 / (4.0 * elementalRes + 1.0));
    }

    private static void link(class_6880<class_1320> attribute, Element element, ModifierType modifierType) {
        ConcurrentHashMap<ModifierType, class_6880<class_1320>> modifierMap = LINKS.getOrDefault((Object)element, new ConcurrentHashMap());
        modifierMap.put(modifierType, attribute);
        LINKS.put(element, modifierMap);
    }

    private static class_6880<class_1320> register(String name, class_1320 attribute) {
        class_6880.class_6883 entry = class_2378.method_47985((class_2378)class_7923.field_41190, (class_2960)SevenElements.identifier(name), (Object)attribute);
        ADDED_ATTRIBUTES.add((class_6880<class_1320>)entry);
        return entry;
    }

    private static class_1320 createAttribute(String name, double base, double min, double max) {
        return new class_1329(name, base, min, max).method_26829(true);
    }

    private static enum ModifierType {
        DMG_BONUS,
        RES;

    }
}

