/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.registry.dynamic;

import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public final class DynamicRegistryLoadEvents {
    public static final Event<BeforeLoad> BEFORE_LOAD = EventFactory.createArrayBacked(BeforeLoad.class, listeners -> registryContext -> {
        for (BeforeLoad listener : listeners) {
            listener.onBeforeLoad(registryContext);
        }
    });
    public static final Event<EntryLoad> ENTRY_LOAD = EventFactory.createArrayBacked(EntryLoad.class, listeners -> entryContext -> {
        for (EntryLoad listener : listeners) {
            listener.onEntryLoad(entryContext);
        }
    });
    public static final Event<AfterLoad> AFTER_LOAD = EventFactory.createArrayBacked(AfterLoad.class, listeners -> registryContext -> {
        for (AfterLoad listener : listeners) {
            listener.onAfterLoad(registryContext);
        }
    });

    @FunctionalInterface
    public static interface AfterLoad {
        public void onAfterLoad(RegistryContext<?> var1);
    }

    public static interface RegistryContext<T> {
        public class_5321<? extends class_2378<T>> registryKey();

        public class_2378<T> registry();

        @Nullable
        default public <R> RegistryContext<R> asKey(class_5321<? extends class_2378<R>> key) {
            return this.registryKey().equals(key) ? (RegistryContext)ClassInstanceUtil.cast(this) : null;
        }

        default public <R> RegistryContext<R> withType(Class<T> entryClazz) {
            return (RegistryContext)ClassInstanceUtil.cast(this);
        }
    }

    public static interface EntryLoad {
        public void onEntryLoad(RegistryEntryContext<?> var1);
    }

    public static interface RegistryEntryContext<T>
    extends RegistryContext<T> {
        public T entry();

        @Override
        @Nullable
        default public <R> RegistryEntryContext<R> asKey(class_5321<? extends class_2378<R>> key) {
            return this.registryKey().equals(key) ? (RegistryEntryContext)ClassInstanceUtil.cast(this) : null;
        }

        @Override
        default public <R> RegistryEntryContext<R> withType(Class<T> entryClazz) {
            return (RegistryEntryContext)ClassInstanceUtil.cast(this);
        }
    }

    @FunctionalInterface
    public static interface BeforeLoad {
        public void onBeforeLoad(RegistryContext<?> var1);
    }

    static class RegistryEntryContextImpl<T>
    implements RegistryEntryContext<T> {
        private final T entry;
        private final class_5321<? extends class_2378<T>> registryKey;
        private final class_2378<T> registry;

        RegistryEntryContextImpl(T entry, class_5321<? extends class_2378<T>> registryKey, class_2378<T> registry) {
            this.entry = entry;
            this.registryKey = registryKey;
            this.registry = registry;
        }

        @Override
        public T entry() {
            return this.entry;
        }

        @Override
        public class_5321<? extends class_2378<T>> registryKey() {
            return this.registryKey;
        }

        @Override
        public class_2378<T> registry() {
            return this.registry;
        }
    }

    static class RegistryContextImpl<T>
    implements RegistryContext<T> {
        private final class_5321<? extends class_2378<T>> registryKey;
        private final class_2378<T> registry;

        RegistryContextImpl(class_5321<? extends class_2378<T>> registryKey, class_2378<T> registry) {
            this.registryKey = registryKey;
            this.registry = registry;
        }

        @Override
        public class_5321<? extends class_2378<T>> registryKey() {
            return this.registryKey;
        }

        @Override
        public class_2378<T> registry() {
            return this.registry;
        }
    }
}

