package io.github.xrickastley.sevenelements.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_10209;
import net.minecraft.class_1259;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_337;
import net.minecraft.class_345;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.util.Array;
import io.github.xrickastley.sevenelements.util.CircleRenderer;
import io.github.xrickastley.sevenelements.util.Functions;

@Mixin(class_337.class)
public class BossBarHudMixin {
	@Shadow
	@Final
	private class_310 client;

	@ModifyConstant(
		method = "render",
		constant = @Constant(intValue = 9, ordinal = 1)
	)
	private int addElementsToRender(int value, @Local class_345 bossBar) {
		if (bossBar.sevenelements$getEntity() == null) return value;

		final int shift = ElementComponent.KEY
			.get(bossBar.sevenelements$getEntity())
			.getAppliedElements()
			.isEmpty() ? 0 : 8;

		return value + shift;
	}

	@Inject(
		method = "renderBossBar(Lnet/minecraft/client/gui/DrawContext;IILnet/minecraft/entity/boss/BossBar;I[Lnet/minecraft/util/Identifier;[Lnet/minecraft/util/Identifier;)V",
		at = @At("TAIL")
	)
	private void renderAppliedElements(class_332 context, int x, int y, class_1259 bossBar, int width, class_2960[] textures, class_2960[] notchedTextures, CallbackInfo ci) {
		if (bossBar.sevenelements$getEntity() == null || bossBar.sevenelements$getEntity().method_29504()) return;

		final double RADIUS = 5;
		final int BOUND = (int) (RADIUS * 2);
		final int SHIFT = 1;
		final int INNER_BOUND = (int) ((RADIUS - SHIFT) * 2);

		class_10209.method_64146().method_15405("seven-elements:elements");

		y += 6;

		final double scaleFactor = class_310.method_1551().method_22683().method_4495();
		final Set<class_2960> existing = new HashSet<>();
		final Array<class_2960> appliedElements = ElementComponent.KEY
			.get(bossBar.sevenelements$getEntity())
			.getAppliedElements()
			.map(Functions.compose(ElementalApplication::getElement, Element::getTexture))
			.filter(existing::add);

		for (int i = 0; i < appliedElements.length(); i++) {
			final class_2960 texture = appliedElements.get(i);
			final int x1 = x + (i * (BOUND + 1));
			final CircleRenderer circleRenderer = new CircleRenderer((x1 + RADIUS) * scaleFactor, (y + RADIUS) * scaleFactor, 0);

			circleRenderer
				.add(RADIUS * scaleFactor, 1, 0x7F646464)
				.draw(context.method_51448().method_23760().method_23761());

			context.method_25290(class_1921::method_62277, texture, x1 + SHIFT, y + SHIFT, 0, 0, INNER_BOUND, INNER_BOUND, INNER_BOUND, INNER_BOUND);
		}
	}
}
