package io.github.xrickastley.sevenelements.util;

import java.util.function.Function;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_9799;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

import io.github.xrickastley.sevenelements.renderer.SevenElementsRenderLayer;
import io.github.xrickastley.sevenelements.renderer.SevenElementsRenderPipelines;
import io.github.xrickastley.sevenelements.renderer.SevenElementsRenderer;

public final class SphereRenderer {
	private static final class_9799 allocator = new class_9799(SevenElementsRenderLayer.getSphere().method_22722());
	private SphereRenderer() {}

	/**
	 * Render a sphere centered at (x,y,z) in world coordinates.
	 *
	 * @param matrices The current {@code MatrixStack}.
	 * @param origin The origin point.
	 * @param radius Sphere radius (in blocks)
	 * @param latSteps Vertical subdivisions
	 * @param lonSteps Horizontal subdivisions
	 * @param color An ARGB int {@code 0xAARRGGBB}
	 */
	public static void render(class_4587 matrices, class_243 origin, float radius, int latSteps, int lonSteps, int color) {
		SphereRenderer.render(matrices, origin, radius, latSteps, lonSteps, pos -> color);
	}

	/**
	 * Render a sphere centered at (x,y,z) in world coordinates.
	 *
	 * @param matrices The current {@code MatrixStack}.
	 * @param origin The origin point.
	 * @param radius Sphere radius (in blocks)
	 * @param latSteps Vertical subdivisions
	 * @param lonSteps Horizontal subdivisions
	 * @param colorFunc A function taking in a {@code Vec3d} and returns an ARGB int {@code 0xAARRGGBB}
	 */
	public static void render(class_4587 matrices, class_243 origin, float radius, int latSteps, int lonSteps, Function<class_243, Integer> colorFunc) {
		if (latSteps < 2) latSteps = 2;
		if (lonSteps < 3) lonSteps = 3;

		// translate to sphere center
		matrices.method_22903();
		matrices.method_22904(origin.field_1352, origin.field_1351, origin.field_1350);

		// grab matrices used by VertexConsumer
		Matrix4f modelMat = matrices.method_23760().method_23761();
		Matrix3f normalMat = matrices.method_23760().method_23762();

		final class_287 buffer = SevenElementsRenderer.createBuffer(allocator, SevenElementsRenderPipelines.SPHERE);

		for (int lat = 0; lat < latSteps; lat++) {
			final double theta1 = Math.PI * lat / (double) latSteps;
			final double theta2 = Math.PI * (lat + 1) / (double) latSteps;

			for (int lon = 0; lon < lonSteps; lon++) {
				final double phi1 = 2.0 * Math.PI * lon / (double) lonSteps;
				final double phi2 = 2.0 * Math.PI * (lon + 1) / (double) lonSteps;

				final class_243 v00 = spherical(radius, theta1, phi1);
				final class_243 v01 = spherical(radius, theta1, phi2);
				final class_243 v10 = spherical(radius, theta2, phi1);
				final class_243 v11 = spherical(radius, theta2, phi2);

				vertex(buffer, modelMat, normalMat, v10, colorFunc.apply(SphereRenderer.relativeClamp(v10, radius)));
				vertex(buffer, modelMat, normalMat, v00, colorFunc.apply(SphereRenderer.relativeClamp(v00, radius)));
				vertex(buffer, modelMat, normalMat, v11, colorFunc.apply(SphereRenderer.relativeClamp(v11, radius)));

				vertex(buffer, modelMat, normalMat, v00, colorFunc.apply(SphereRenderer.relativeClamp(v00, radius)));
				vertex(buffer, modelMat, normalMat, v11, colorFunc.apply(SphereRenderer.relativeClamp(v11, radius)));
				vertex(buffer, modelMat, normalMat, v01, colorFunc.apply(SphereRenderer.relativeClamp(v01, radius)));
			}
		}

		SevenElementsRenderLayer.getSphere().method_60895(buffer.method_60800());

		matrices.method_22909();
	}

	private static class_243 spherical(double r, double theta, double phi) {
		double x = r * Math.sin(theta) * Math.cos(phi);
		double y = r * Math.cos(theta);
		double z = r * Math.sin(theta) * Math.sin(phi);
		return new class_243(x, y, z);
	}

	private static void vertex(class_287 buffer, Matrix4f projMat, Matrix3f normalMat, class_243 pos, int color) {
		buffer
			.method_22918(projMat, (float)pos.field_1352, (float)pos.field_1351, (float)pos.field_1350)
			.method_39415(color);
	}

	private static class_243 relativeClamp(class_243 pos, float radius) {
		final class_243 relPos = pos.method_1021(1 / radius);

		return new class_243(
			class_3532.method_15350(relPos.field_1352, -1, 1),
			class_3532.method_15350(relPos.field_1351, -1, 1),
			class_3532.method_15350(relPos.field_1350, -1, 1)
		);
	}
}
