package io.github.xrickastley.sevenelements.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;

import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.element.InternalCooldownTag;
import io.github.xrickastley.sevenelements.element.InternalCooldownType;
import io.github.xrickastley.sevenelements.registry.SevenElementsRegistryKeys;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7924;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class DamageCommand {
	private static final SimpleCommandExceptionType INVULNERABLE_EXCEPTION = new SimpleCommandExceptionType(class_2561.method_43471("commands.damage.invulnerable"));

	public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
		final CommandNode<class_2168> elementalDamageNode =
			class_2170
				.method_9247("element")
				.then(
					method_9244("element", ElementArgumentType.element())
					.then(
						method_9244("gaugeUnits", DoubleArgumentType.doubleArg(0))
						.then(
							method_9244("tag", InternalCooldownTagType.tag())
							.then(
								method_9244("type", class_7733.method_45603(registryAccess, SevenElementsRegistryKeys.INTERNAL_COOLDOWN_TYPE))
								.executes(context -> execute(context, class_2186.method_9313(context, "target"), FloatArgumentType.getFloat(context, "amount"), context.getSource().method_9225().method_48963().method_48830()))
								.then(
									method_9247("by")
									.then(
										method_9244("entity", class_2186.method_9309())
										.executes(context -> execute(context, class_2186.method_9313(context, "target"), FloatArgumentType.getFloat(context, "amount"), new class_1282(class_7733.method_45602(context, "damageType", class_7924.field_42534), class_2186.method_9313(context, "entity"))))
										.then(
											method_9247("from")
											.then(
												method_9244("cause", class_2186.method_9309())
												.executes(context -> execute(context, class_2186.method_9313(context, "target"), FloatArgumentType.getFloat(context, "amount"), new class_1282(class_7733.method_45602(context, "damageType", class_7924.field_42534), class_2186.method_9313(context, "entity"), class_2186.method_9313(context, "cause"))))
											)
										)
									)
								)
							)
						)
					)
				)
				.build();

		dispatcher
			.getRoot()
			.getChild("damage")
			.getChild("target")
			.getChild("amount")
			.getChild("damageType")
			.addChild(elementalDamageNode);
	}

	private static int execute(CommandContext<class_2168> context, class_1297 target, float amount, class_1282 damageSource) throws CommandSyntaxException {
		final Element element = ElementArgumentType.getElement(context, "element");
		final double gaugeUnits = DoubleArgumentType.getDouble(context, "gaugeUnits");
		final InternalCooldownTag tag = InternalCooldownTagType.getTag(context, "tag");
		final InternalCooldownType type = class_7733.method_45602(context, "type", SevenElementsRegistryKeys.INTERNAL_COOLDOWN_TYPE).comp_349();

		if (!(target instanceof final class_1309 livingTarget))
			return CommandUtils.sendError(context, class_2561.method_43469("commands.element.failed.entity", target.method_5476()));

		final ElementalDamageSource eds = new ElementalDamageSource(
			damageSource,
			ElementalApplications.gaugeUnits(livingTarget, element, gaugeUnits, false),
			InternalCooldownContext.ofType(damageSource.method_5529(), tag, type)
		).shouldInfuse(false);

		final class_2561 icdText = class_2561.method_43473()
			.method_10852(tag.getText())
			.method_27693("/")
			.method_10852(type.getText());

		if (target.method_64397(context.getSource().method_9225(), eds, amount)) {
			context
				.getSource()
				.method_9226(() -> class_2561.method_43469("commands.seven-elements.damage.success", amount, ElementalApplications.gaugeUnits(livingTarget, element, gaugeUnits, false).getText(), icdText, target.method_5476()), true);

			return 1;
		} else {
			throw INVULNERABLE_EXCEPTION.create();
		}
	}
}
