package io.github.xrickastley.sevenelements.mixin;

import com.llamalad7.mixinextras.sugar.Local;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import io.github.xrickastley.sevenelements.interfaces.IEnderDragonFight;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;
import io.github.xrickastley.sevenelements.util.Functions;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1510;
import net.minecraft.class_1569;
import net.minecraft.class_1937;
import net.minecraft.class_2881;
import net.minecraft.class_3218;

@Mixin(class_1510.class)
public abstract class EnderDragonEntityMixin
	extends class_1308
	implements class_1569
{
	public EnderDragonEntityMixin(class_1299<? extends class_1510> entityType, class_1937 world) {
		super(class_1299.field_6116, world);

		throw new AssertionError();
	}

	@Inject(
		method = "setFight",
		at = @At("HEAD")
	)
	private void addEnderDragonEntityToFight(class_2881 fight, CallbackInfo ci) {
		ClassInstanceUtil.ifPresentMapped(
			fight,
			IEnderDragonFight.class::cast, 
			Functions.withArgument(IEnderDragonFight::sevenelements$setDragon, ClassInstanceUtil.cast(this))
		);
	}

	@Inject(
		method = "tickMovement",
		at = @At("HEAD")
	)
	private void sendDragonUpdates(CallbackInfo ci) {
		if (!(this.method_73183() instanceof final class_3218 world)) return;

		ClassInstanceUtil.ifPresentMapped(
			world.method_29198(),
			IEnderDragonFight.class::cast, 
			Functions.withArgument(IEnderDragonFight::sevenelements$setDragon, ClassInstanceUtil.cast(this))
		);
	}

	@Inject(
		method = "tickMovement",
		at = @At(
			value = "INVOKE_ASSIGN",
			target = "Lnet/minecraft/server/world/ServerWorld;getEnderDragonFight()Lnet/minecraft/entity/boss/dragon/EnderDragonFight;"
		)
	)
	private void setDragonOnFightUpdate(CallbackInfo ci, @Local class_2881 enderDragonFight) {
		ClassInstanceUtil.ifPresentMapped(
			enderDragonFight,
			IEnderDragonFight.class::cast, 
			Functions.withArgument(IEnderDragonFight::sevenelements$setDragon, ClassInstanceUtil.cast(this))
		);
	}
}
