package io.github.xrickastley.sevenelements.renderer.entity;

import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.entity.DendroCoreEntity;
import io.github.xrickastley.sevenelements.renderer.entity.model.DendroCoreEntityModel;
import io.github.xrickastley.sevenelements.renderer.entity.state.DendroCoreEntityState;
import io.github.xrickastley.sevenelements.util.Ease;
import io.github.xrickastley.sevenelements.util.MathHelper2;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5617;
import net.minecraft.class_922;

public class DendroCoreEntityRenderer extends class_922<DendroCoreEntity, DendroCoreEntityState, DendroCoreEntityModel> {
	public DendroCoreEntityRenderer(class_5617.class_5618 context) {
		super(
			context,
			DendroCoreEntityRenderer.createModel(context),
			0.5f
		);
	}

	private static DendroCoreEntityModel createModel(class_5617.class_5618 context) {
		return new DendroCoreEntityModel(context.method_32167(DendroCoreEntityModel.MODEL_LAYER));
	}

	@Override
	public class_2960 getTexture(DendroCoreEntityState state) {
		return SevenElements.identifier("textures/entity/dendro_core/dendro_core.png");
	}

	@Override
	public DendroCoreEntityState method_55269() {
		return new DendroCoreEntityState();
	}

	@Override
	public void updateRenderState(DendroCoreEntity dendroCore, DendroCoreEntityState state, float f) {
		super.method_62355(dendroCore, state, f);

		state.apply(dendroCore);
	}

	@Override
	public void render(DendroCoreEntityState livingEntityRenderState, class_4587 matrixStack, class_11659 orderedRenderCommandQueue, class_12075 cameraRenderState) {
		this.field_4672 = 0f;
		this.field_4673 = 0f;

		super.method_4054(livingEntityRenderState, matrixStack, orderedRenderCommandQueue, cameraRenderState);
	}

	@Override
	protected void scale(DendroCoreEntityState state, class_4587 matrices) {
		super.method_4042(state, matrices);

		final float delta = class_310.method_1551().method_61966().method_60637(false);
		final double explodeProgress = Ease.IN_QUAD.applyLerp(MathHelper2.endOffset(state.field_53328 + delta, 2, 0, 120), 0, 1.5);
		final float scale = !state.isHyperbloom()
			? 0.5f + (float) (explodeProgress * 5)
			: 0.35f;

		matrices.method_46416(0, 0, 0);
		matrices.method_22905(scale, scale, scale);
	}

	@Override
	protected void renderLabelIfPresent(DendroCoreEntityState state, class_4587 matrices, class_11659 queue, class_12075 cameraRenderState) {}
}
