/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.element.reaction;

import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReaction;
import io.github.xrickastley.sevenelements.factory.SevenElementsGameRules;
import io.github.xrickastley.sevenelements.mixin.WorldAccessor;
import io.github.xrickastley.sevenelements.registry.SevenElementsDamageTypes;
import io.github.xrickastley.sevenelements.util.NonEntityDamagingExplosion;
import io.github.xrickastley.sevenelements.util.TextHelper;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2664;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_5362;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class OverloadedElementalReaction
extends ElementalReaction {
    OverloadedElementalReaction() {
        super(new ElementalReaction.Settings("Overloaded", SevenElements.identifier("overloaded"), (class_2561)TextHelper.reaction("reaction.seven-elements.overloaded", "#fc7fa4")).setReactionCoefficient(1.0).setAuraElement(Element.PYRO, 2).setTriggeringElement(Element.ELECTRO, 3).reversable(true));
    }

    @Override
    protected void onReaction(class_1309 entity, ElementalApplication auraElement, ElementalApplication triggeringElement, double reducedGauge, @Nullable class_1309 origin) {
        class_1937 class_19372 = entity.method_73183();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        float power = 3.0f;
        NonEntityDamagingExplosion explosion = new NonEntityDamagingExplosion(world, null, new class_5362(), entity.method_73189(), 3.0f, true, world.method_64395().method_8355(SevenElementsGameRules.OVERLOADED_EXPLOSIONS_DAMAGE_BLOCKS) ? class_1927.class_4179.field_18687 : class_1927.class_4179.field_40878);
        explosion.explode();
        explosion.getAffectedEntities().forEach(e -> this.damage((class_1297)e, (class_1297)origin));
        for (class_3222 serverPlayerEntity : world.method_18456()) {
            if (serverPlayerEntity.method_5707(entity.method_73189()) >= 4096.0) continue;
            serverPlayerEntity.field_13987.method_14364((class_2596)new class_2664(entity.method_73189(), explosion.method_55107(), 0, Optional.ofNullable(explosion.getKnockbackByPlayer().get(serverPlayerEntity)), (class_2394)(explosion.isSmall() ? class_2398.field_11236 : class_2398.field_11221), (class_6880)class_3417.field_15152, WorldAccessor.getExplosionBlockParticles()));
        }
    }

    private void damage(class_1297 entity, @Nullable class_1297 origin) {
        if (!(entity instanceof class_1309)) {
            return;
        }
        class_1309 living = (class_1309)entity;
        class_1937 class_19372 = entity.method_73183();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        ElementalApplication application = ElementalApplications.gaugeUnits(living, Element.PYRO, 0.0);
        ElementalDamageSource source = new ElementalDamageSource(entity.method_48923().method_48796(SevenElementsDamageTypes.OVERLOADED, origin), application, InternalCooldownContext.ofNone(entity)).shouldApplyDMGBonus(false);
        float amount = ElementalReaction.getReactionDamage(entity, 2.75);
        if (entity == origin) {
            amount = 0.0f;
        }
        entity.method_64397(world, (class_1282)source, amount);
    }
}

