/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.renderer.genshin;

import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.renderer.SevenElementsRenderLayer;
import io.github.xrickastley.sevenelements.renderer.SevenElementsRenderPipelines;
import io.github.xrickastley.sevenelements.renderer.SevenElementsRenderer;
import io.github.xrickastley.sevenelements.util.Ease;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_9799;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public final class ElementEntry {
    private static final float BLINK_SECONDS = 1.5f;
    private static final float BLINK_COUNT = 3.0f;
    private static final class_9799 allocator = SevenElementsRenderer.createAllocator(0x400000);
    private final Element element;
    private final double secondsLeft;
    private final long appliedAt;
    private final float tickDelta;

    public ElementEntry(Element element, double secondsLeft, long appliedAt, float tickDelta) {
        this.element = element;
        this.secondsLeft = secondsLeft;
        this.appliedAt = appliedAt;
        this.tickDelta = tickDelta;
    }

    public static ElementEntry of(ElementalApplication application, float tickDelta) {
        return new ElementEntry(application.getElement(), (double)((float)application.getRemainingTicks() - tickDelta) / 20.0, application.getAppliedAt(), tickDelta);
    }

    public Element getElement() {
        return this.element;
    }

    private long getAppliedTicks(class_1297 entity) {
        return entity.method_73183().method_8510() - this.appliedAt;
    }

    public void render(class_1309 entity, class_4587 matrixStack, class_4184 camera, float offset) {
        float blinkInterval = 0.5f;
        float intervalSplit = 0.25f;
        matrixStack.method_22903();
        matrixStack.method_22904(0.0, entity.method_5829().method_17940() * 1.1, 0.0);
        matrixStack.method_34425((Matrix4fc)new Matrix4f().rotation((Quaternionfc)camera.method_23767()));
        matrixStack.method_22905(0.5f, 0.5f, 0.5f);
        float alpha = (float)(this.secondsLeft <= 1.75 ? (this.secondsLeft % 0.5 <= 0.25 ? class_3532.method_16436((double)(this.secondsLeft % 0.5 / 0.25), (double)0.0, (double)1.0) : class_3532.method_16436((double)((this.secondsLeft % 0.5 - 0.25) / 0.25), (double)1.0, (double)0.0)) : 1.0);
        this.draw(matrixStack, camera, offset, alpha);
        if (this.getAppliedTicks((class_1297)entity) <= 5L) {
            double animationProgress = Ease.LINEAR.applyLerpProgress((float)this.getAppliedTicks((class_1297)entity) + this.tickDelta, 1.0, 6.0);
            float scale2 = (float)(animationProgress * 2.0);
            float alpha2 = (float)(1.0 - animationProgress * 0.5);
            matrixStack.method_22905(scale2, scale2, scale2);
            this.draw(matrixStack, camera, offset, alpha2);
        }
        matrixStack.method_22909();
    }

    private void draw(class_4587 matrixStack, class_4184 camera, float offset, float alpha) {
        class_2960 texture = this.element.getTexture();
        if (texture == null) {
            return;
        }
        class_287 buffer = SevenElementsRenderer.createBuffer(allocator, SevenElementsRenderPipelines.ELEMENTS);
        float finalXOffset = -0.5f + offset;
        Matrix4f positionMatrix = matrixStack.method_23760().method_23761();
        buffer.method_22918(positionMatrix, 0.0f + finalXOffset, 0.0f, 0.0f).method_22913(0.0f, 1.0f).method_22915(1.0f, 1.0f, 1.0f, alpha);
        buffer.method_22918(positionMatrix, 1.0f + finalXOffset, 0.0f, 0.0f).method_22913(1.0f, 1.0f).method_22915(1.0f, 1.0f, 1.0f, alpha);
        buffer.method_22918(positionMatrix, 1.0f + finalXOffset, 1.0f, 0.0f).method_22913(1.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha);
        buffer.method_22918(positionMatrix, 0.0f + finalXOffset, 1.0f, 0.0f).method_22913(0.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha);
        SevenElementsRenderLayer.getElements(texture).method_60895(buffer.method_60800());
    }
}

