package io.github.xrickastley.sevenelements.interfaces;

import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import org.jetbrains.annotations.Nullable;

public interface ILivingEntity {
	/**
	 * Gets the "planned" attacker. This is updated at the <i>very</i> start of the damage method,
	 * meaning that the attacker may not be able to attack after all succeeding conditions are
	 * checked. <br> <br>
	 *
	 * This is the attacker of the <i>most recent</i> {@code DamageSource} passed through
	 * {@link class_1309#method_64397 LivingEntity#damage}.
	 *
	 * @see class_1309#method_6065()
	 */
	default @Nullable class_1297 sevenelements$getPlannedAttacker() {
		return null;
	}

	/**
	 * Gets the "planned" damage source. This is updated at the <i>very</i> start of the damage
	 * method, meaning that the damage source may not be applied after all succeeding conditions
	 * are checked. <br> <br>
	 *
	 * This is the <i>most recent</i> {@code DamageSource} passed through
	 * {@link class_1309#method_64397 LivingEntity#damage}.
	 */
	default @Nullable class_1282 sevenelements$getPlannedDamageSource() {
		return null;
	}

	/**
	 * Sets whether the damage was blocked by the Crystallize Shield. <br> <br>
	 *
	 * To <b>only</b> be used by subclasses of {@code LivingEntity} that don't call upon
	 * {@link class_1309#method_6074 LivingEntity#applyDamage}.
	 */
	default void sevenelements$setBlockedByCrystallizeShield(boolean blocked) {}
}
