package io.github.xrickastley.sevenelements.block;

import com.mojang.serialization.MapCodec;

import org.jetbrains.annotations.Nullable;

import io.github.xrickastley.sevenelements.factory.SevenElementsGameRules;
import io.github.xrickastley.sevenelements.screen.ElementalInfusionScreenHandler;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3914;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_747;
import net.minecraft.class_8012;

public final class InfusionTableBlock extends class_2383 {
	public static final MapCodec<InfusionTableBlock> CODEC = method_54094(InfusionTableBlock::new);
	public static final class_2753 FACING = class_2383.field_11177;
	public static final class_2754<class_2756> HALF = class_2741.field_12533;
	private static final class_265 LOWER;
	private static final class_265 UPPER;
	private static final class_265 SHAPE;

	InfusionTableBlock() {
		this(class_4970.class_2251.method_9637());
	}

	private InfusionTableBlock(class_4970.class_2251 settings) {
		super(
			settings
				.method_29292()
				.method_9629(3, 4)
				.method_50012(class_3619.field_15972)
		);

		this.method_9590(
			this.field_10647.method_11664()
				.method_11657(field_11177, class_2350.field_11043)
				.method_11657(HALF, class_2756.field_12607)
		);
	}

	@Override
	public class_2680 method_9605(class_1750 ctx) {
		return super.method_9605(ctx)
			.method_11657(field_11177, ctx.method_8042());
	}

	@Override
	public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
		final class_2338 blockPos = pos.method_10084();

		world.method_8501(blockPos, this.method_9564().method_11657(HALF, class_2756.field_12609));
	}

	@Override
	public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
		if (state.method_11654(HALF) == class_2756.field_12607 && state.method_26204() == this) {
			if (world.method_8320(pos.method_10084()).method_26204() == this) world.method_8650(pos.method_10084(), false);
		} else if (state.method_11654(HALF) == class_2756.field_12609 && state.method_26204() == this) {
			if (world.method_8320(pos.method_10074()).method_26204() == this) world.method_8650(pos.method_10074(), false);
		}

		return super.method_9576(world, pos, state, player);
	}

	@Override
	protected MapCodec<? extends class_2383> method_53969() {
		return field_46280;
	}

	@Override
	protected void method_9515(class_2690<class_2248, class_2680> builder) {
		super.method_9515(builder);

		builder.method_11667(field_11177, HALF);
	}

	@Override
	protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
		if (world.field_9236) return class_1269.field_5812;

		if (world.method_8450().method_8355(SevenElementsGameRules.INFUSION_TABLE)) {
			player.method_17355(state.method_26196(world, pos));
		} else  {
			player.method_43496(
				class_2561.method_43471("container.seven-elements.infusion_table.fail_by_gamerule").method_54663(class_8012.field_46652)
			);
		}

		return class_1269.field_21466;
	}

	@Override
	protected @Nullable class_3908 method_17454(class_2680 state, class_1937 world, class_2338 pos) {
		return new class_747(
			(syncId, inventory, player) -> new ElementalInfusionScreenHandler(syncId, inventory, class_3914.method_17392(world, pos)),
			class_2561.method_43471("container.seven-elements.infusion_table")
		);
	}

	@Override
	protected boolean method_9526(class_2680 state) {
		return true;
	}

	@Override
	protected class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
		return state.method_11654(HALF) == class_2756.field_12609
			? UPPER.method_1096(0, -1, 0)
			: LOWER;
	}

	@Override
	protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
		return state.method_11654(HALF) == class_2756.field_12609
			? world.method_8320(pos.method_10074()).method_26204() != this
				? UPPER.method_1096(0, -1, 0)
				: class_259.method_1073()
			: world.method_8320(pos.method_10084()).method_26204() != this
				? LOWER
				: SHAPE;
	}

	@Override
	protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
		if (state.method_11654(HALF) != class_2756.field_12609)
			return super.method_9558(state, world, pos);

		final class_2680 blockState = world.method_8320(pos.method_10074());

		return blockState.method_27852(this) && blockState.method_11654(HALF) == class_2756.field_12607;
	}

	static {
		LOWER = class_259.method_17786(
			class_2248.method_9541(0, 0, 0, 16, 2, 16),
			class_259.method_17786(
				class_2248.method_9541(3, 2, 3, 13, 4, 13),
				class_2248.method_9541(2, 2, 2, 4, 4, 4),
				class_2248.method_9541(12, 2, 2, 14, 4, 4),
				class_2248.method_9541(2, 2, 14, 4, 4, 14),
				class_2248.method_9541(12, 2, 12, 14, 4, 14)
			),
			class_2248.method_9541(5, 4, 5, 11, 14, 11),
			class_2248.method_9541(0, 14, 0, 16, 16, 16)
		);

		UPPER = class_259.method_1084(
			class_2248.method_9541(3, 16, 3, 13, 18, 13),
			class_2248.method_9541(0, 18, 0, 16, 20, 16)
		);

		SHAPE = class_259.method_1084(LOWER, UPPER);
	}
}
