package io.github.xrickastley.sevenelements.element.reaction;

import org.jetbrains.annotations.Nullable;

import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.factory.SevenElementsGameRules;
import io.github.xrickastley.sevenelements.registry.SevenElementsDamageTypes;
import io.github.xrickastley.sevenelements.util.NonEntityDamagingExplosion;
import io.github.xrickastley.sevenelements.util.TextHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1927.class_4179;
import net.minecraft.class_1937;
import net.minecraft.class_2664;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5362;

public class OverloadedElementalReaction extends ElementalReaction {
	OverloadedElementalReaction() {
		super(
			new Settings("Overloaded", SevenElements.identifier("overloaded"), TextHelper.reaction("reaction.seven-elements.overloaded", "#fc7fa4"))
				.setReactionCoefficient(1.0)
				.setAuraElement(Element.PYRO, 2)
				.setTriggeringElement(Element.ELECTRO, 3)
				.reversable(true)
		);
	}

	@Override
	protected void onReaction(class_1309 entity, ElementalApplication auraElement, ElementalApplication triggeringElement, double reducedGauge, @Nullable class_1309 origin) {
		final class_1937 world = entity.method_37908();

		if (world.field_9236) return;

		final double x = entity.method_23317();
		final double y = entity.method_23318();
		final double z = entity.method_23321();
		final float power = 3;

		final NonEntityDamagingExplosion explosion = new NonEntityDamagingExplosion(
			world,
			null,
			new class_5362(),
			x,
			y,
			z,
			power,
			true,
			world.method_8450().method_8355(SevenElementsGameRules.OVERLOADED_EXPLOSIONS_DAMAGE_BLOCKS)
				? class_4179.field_18687
				: class_4179.field_40878
		);

		explosion.collectBlocksAndPushEntities();
		explosion.method_8350(world.field_9236);
		explosion
			.getAffectedEntities()
			.forEach(e -> damage(e, origin));

		//  Sync the explosion effect to the client if the explosion is created on the server
		if (!(world instanceof class_3218 serverWorld)) return;

		if (!explosion.method_46667()) explosion.method_8352();

		for (class_3222 serverPlayerEntity : serverWorld.method_18456()) {
			if (serverPlayerEntity.method_5649(x, y, z) >= 4096.0) continue;

			serverPlayerEntity.field_13987.method_14364(
				new class_2664(
					x,
					y,
					z,
					power,
					explosion.method_8346(),
					explosion.method_8351().get(serverPlayerEntity),
					explosion.method_55111(),
					explosion.method_55112(),
					explosion.method_55113(),
					explosion.method_55114()
				)
			);
		}
	}

	private void damage(class_1297 entity, @Nullable class_1297 origin) {
		if (!(entity instanceof final class_1309 living)) return;

		final ElementalApplication application = ElementalApplications.gaugeUnits(living, Element.PYRO, 0);
		final ElementalDamageSource source = new ElementalDamageSource(
			entity
				.method_48923()
				.method_48796(SevenElementsDamageTypes.OVERLOADED, origin),
			application,
			InternalCooldownContext.ofNone(entity)
		).shouldApplyDMGBonus(false);

		float amount = ElementalReaction.getReactionDamage(entity, 2.75);

		if (entity == origin) amount = 0;

		entity.method_5643(source, amount);
	}
}
