package io.github.xrickastley.sevenelements.entity;

import java.util.function.Supplier;

import io.github.xrickastley.sevenelements.SevenElements;

import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_2378;
import net.minecraft.class_5132;
import net.minecraft.class_7923;

public class SevenElementsEntityTypes {
	public static final class_1299<DendroCoreEntity> DENDRO_CORE = class_1299.class_1300
		.<DendroCoreEntity>method_5903(DendroCoreEntity::new, class_1311.field_17715)
		.method_17687(0.3125f, 0.4296875f)
		.method_27299(64)
		.build();

	public static final class_1299<CrystallizeShardEntity> CRYSTALLIZE_SHARD = class_1299.class_1300
		.<CrystallizeShardEntity>method_5903(CrystallizeShardEntity::new, class_1311.field_17715)
		.method_17687(0.3125f, 0.875f)
		.method_27299(64)
		.build();

	public static void register() {
		register("dendro_core", SevenElementsEntityTypes.DENDRO_CORE, SevenElementsEntity::getAttributeBuilder);
		register("crystallize_shard", SevenElementsEntityTypes.CRYSTALLIZE_SHARD, SevenElementsEntity::getAttributeBuilder);
	}

	private static <T extends class_1309> void register(String id, class_1299<T> entityType, Supplier<class_5132.class_5133> builderSupplier) {
		register(id, entityType, builderSupplier.get());
	}

	private static <T extends class_1309> void register(String id, class_1299<T> entityType, class_5132.class_5133 builder) {
		FabricDefaultAttributeRegistry.register(entityType, builder);

		class_2378.method_10230(class_7923.field_41177, SevenElements.identifier(id), entityType);
	}
}
